/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.MetricsRegistryImpl;
import io.smallrye.metrics.SmallRyeMetricsMessages;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Set;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.Counted;

@Counted
@Interceptor
@Priority(value=1010)
public class CountedInterceptor {
    private final MetricRegistry registry = MetricRegistries.get(MetricRegistry.Type.APPLICATION);

    @Inject
    CountedInterceptor() {
    }

    @AroundConstruct
    Object countedConstructor(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getConstructor());
    }

    @AroundInvoke
    Object countedMethod(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getMethod());
    }

    @AroundTimeout
    Object countedTimeout(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getMethod());
    }

    private <E extends Member & AnnotatedElement> Object countedCallable(InvocationContext context, E element) throws Exception {
        Set<MetricID> ids = ((MetricsRegistryImpl)this.registry).getMemberToMetricMappings().getCounters(new CDIMemberInfoAdapter<E>().convert(element));
        if (ids == null || ids.isEmpty()) {
            throw SmallRyeMetricsMessages.msg.noMetricMappedForMember(element);
        }
        ids.stream().map(metricID -> {
            Counter metric = (Counter)this.registry.getCounters().get(metricID);
            if (metric == null) {
                throw SmallRyeMetricsMessages.msg.noMetricFoundInRegistry(MetricType.COUNTER, (MetricID)metricID);
            }
            return metric;
        }).forEach(Counter::inc);
        return context.proceed();
    }
}

