/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.annotation.Experimental;
import java.util.Comparator;
import java.util.Objects;

@Experimental(value="Extension to the original ConfigSource to allow retrieval of additional metadata on config lookup")
public class ConfigValue
implements org.eclipse.microprofile.config.ConfigValue {
    private final String name;
    private final String value;
    private final String rawValue;
    private final String profile;
    private final String configSourceName;
    private final int configSourceOrdinal;
    private final int configSourcePosition;
    private final int lineNumber;
    static final Comparator<ConfigValue> CONFIG_SOURCE_COMPARATOR = new Comparator<ConfigValue>(){

        @Override
        public int compare(ConfigValue original, ConfigValue candidate) {
            int result = Integer.compare(original.configSourceOrdinal, candidate.configSourceOrdinal);
            if (result != 0) {
                return result;
            }
            return Integer.compare(original.configSourcePosition, candidate.configSourcePosition) * -1;
        }
    };

    private ConfigValue(ConfigValueBuilder builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.rawValue = builder.rawValue;
        this.profile = builder.profile;
        this.configSourceName = builder.configSourceName;
        this.configSourceOrdinal = builder.configSourceOrdinal;
        this.configSourcePosition = builder.configSourcePosition;
        this.lineNumber = builder.lineNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getNameProfiled() {
        return this.profile != null ? "%" + this.profile + "." + this.name : this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getSourceName() {
        return this.getConfigSourceName();
    }

    public int getSourceOrdinal() {
        return this.getConfigSourceOrdinal();
    }

    public String getConfigSourceName() {
        return this.configSourceName;
    }

    public int getConfigSourceOrdinal() {
        return this.configSourceOrdinal;
    }

    public int getConfigSourcePosition() {
        return this.configSourcePosition;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLocation() {
        return this.lineNumber != -1 ? this.configSourceName + ":" + this.lineNumber : this.configSourceName;
    }

    public ConfigValue withName(String name) {
        return this.from().withName(name).build();
    }

    public ConfigValue withValue(String value) {
        return this.from().withValue(value).build();
    }

    public ConfigValue withProfile(String profile) {
        return this.from().withProfile(profile).build();
    }

    public ConfigValue withConfigSourceName(String configSourceName) {
        return this.from().withConfigSourceName(configSourceName).build();
    }

    public ConfigValue withConfigSourceOrdinal(int configSourceOrdinal) {
        return this.from().withConfigSourceOrdinal(configSourceOrdinal).build();
    }

    public ConfigValue withConfigSourcePosition(int configSourcePosition) {
        return this.from().withConfigSourcePosition(configSourcePosition).build();
    }

    public ConfigValue withLineNumber(int lineNumber) {
        return this.from().withLineNumber(lineNumber).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigValue that = (ConfigValue)o;
        return this.name.equals(that.name) && this.value.equals(that.value) && this.rawValue.equals(that.rawValue) && this.configSourceName.equals(that.configSourceName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.configSourceName);
    }

    public String toString() {
        return "ConfigValue{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", rawValue='" + this.rawValue + '\'' + ", profile='" + this.profile + '\'' + ", configSourceName='" + this.configSourceName + '\'' + ", configSourceOrdinal=" + this.configSourceOrdinal + ", configSourcePosition=" + this.configSourcePosition + ", lineNumber=" + this.lineNumber + '}';
    }

    ConfigValueBuilder from() {
        return new ConfigValueBuilder().withName(this.name).withValue(this.value).withRawValue(this.rawValue).withProfile(this.profile).withConfigSourceName(this.configSourceName).withConfigSourceOrdinal(this.configSourceOrdinal).withConfigSourcePosition(this.configSourcePosition).withLineNumber(this.lineNumber);
    }

    public static ConfigValueBuilder builder() {
        return new ConfigValueBuilder();
    }

    public static class ConfigValueBuilder {
        private String name;
        private String value;
        private String rawValue;
        private String profile;
        private String configSourceName;
        private int configSourceOrdinal;
        private int configSourcePosition;
        private int lineNumber = -1;

        public ConfigValueBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ConfigValueBuilder withValue(String value) {
            this.value = value;
            return this;
        }

        public ConfigValueBuilder withRawValue(String rawValue) {
            this.rawValue = rawValue;
            return this;
        }

        public ConfigValueBuilder withProfile(String profile) {
            this.profile = profile;
            return this;
        }

        public ConfigValueBuilder withConfigSourceName(String configSourceName) {
            this.configSourceName = configSourceName;
            return this;
        }

        public ConfigValueBuilder withConfigSourceOrdinal(int configSourceOrdinal) {
            this.configSourceOrdinal = configSourceOrdinal;
            return this;
        }

        public ConfigValueBuilder withConfigSourcePosition(int configSourcePosition) {
            this.configSourcePosition = configSourcePosition;
            return this;
        }

        public ConfigValueBuilder withLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public ConfigValue build() {
            return new ConfigValue(this);
        }
    }
}

