/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.CapabilityProvider;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.controller.UnaryCapabilityNameResolver;
import org.jboss.as.clustering.controller.UnaryRequirementCapability;
import org.jboss.as.clustering.controller.validation.EnumValidator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.service.UnaryRequirement;
import org.wildfly.clustering.web.service.WebProviderRequirement;
import org.wildfly.clustering.web.service.WebRequirement;
import org.wildfly.extension.clustering.web.DistributableWebExtension;
import org.wildfly.extension.clustering.web.LocalAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.NoAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.SessionGranularity;
import org.wildfly.extension.clustering.web.SessionMarshallerFactory;

public class SessionManagementResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration> {
    private final UnaryOperator<ResourceDescriptor> configurator;
    private final ResourceServiceConfiguratorFactory factory;

    public SessionManagementResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceConfiguratorFactory factory) {
        super(path, DistributableWebExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{path, PathElement.pathElement((String)"session-management")}));
        this.configurator = configurator;
        this.factory = factory;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = ((ResourceDescriptor)this.configurator.apply(new ResourceDescriptor(this.getResourceDescriptionResolver()))).addAttributes(Attribute.class).addCapabilities(Capability.class);
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler(this.factory);
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register(registration);
        new NoAffinityResourceDefinition().register(registration);
        new LocalAffinityResourceDefinition().register(registration);
        return registration;
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        GRANULARITY("granularity", ModelType.STRING, null){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(SessionGranularity.class));
            }
        }
        ,
        MARSHALLER("marshaller", ModelType.STRING, new ModelNode(SessionMarshallerFactory.JBOSS.name())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(SessionMarshallerFactory.class));
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(defaultValue == null)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Capability implements CapabilityProvider,
    UnaryOperator<RuntimeCapability.Builder<Void>>
    {
        SESSION_MANAGEMENT_PROVIDER((UnaryRequirement)WebProviderRequirement.SESSION_MANAGEMENT_PROVIDER);

        private final org.jboss.as.clustering.controller.Capability capability;

        private Capability(UnaryRequirement requirement) {
            this.capability = new UnaryRequirementCapability(requirement, (UnaryOperator)this);
        }

        public org.jboss.as.clustering.controller.Capability getCapability() {
            return this.capability;
        }

        @Override
        public RuntimeCapability.Builder<Void> apply(RuntimeCapability.Builder<Void> builder) {
            return builder.setDynamicNameMapper((Function)UnaryCapabilityNameResolver.DEFAULT).addRequirements(new String[]{WebRequirement.ROUTING_PROVIDER.getName()});
        }
    }
}

