/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.api;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.faulttolerance.api.FaultToleranceSpi;
import java.util.ServiceLoader;

@Experimental(value="first attempt at providing programmatic API")
public final class FaultToleranceSpiAccess {
    public static FaultToleranceSpi get() {
        return Holder.INSTANCE;
    }

    private static FaultToleranceSpi instantiateSpi() {
        FaultToleranceSpi bestCandidate = null;
        int bestCandidatePriority = Integer.MIN_VALUE;
        for (FaultToleranceSpi candidate : ServiceLoader.load(FaultToleranceSpi.class)) {
            if (!candidate.applies() || candidate.priority() <= bestCandidatePriority) continue;
            bestCandidate = candidate;
        }
        if (bestCandidate == null) {
            throw new IllegalStateException("Could not find implementation of FaultToleranceSpi, add a dependency on io.smallrye:smallrye-fault-tolerance or io.smallrye:smallrye-fault-tolerance-standalone");
        }
        return bestCandidate;
    }

    static /* synthetic */ FaultToleranceSpi access$000() {
        return FaultToleranceSpiAccess.instantiateSpi();
    }

    private static class Holder {
        private static final FaultToleranceSpi INSTANCE = FaultToleranceSpiAccess.access$000();

        private Holder() {
        }
    }
}

