/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.servlet.api.CrawlerSessionManagerConfig;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.JSPConfig;
import org.wildfly.extension.undertow.SessionCookieConfig;
import org.xnio.XnioWorker;

public final class ServletContainerService
implements Service<ServletContainerService> {
    private final Consumer<ServletContainerService> serviceConsumer;
    private final Supplier<SessionPersistenceManager> sessionPersistenceManager;
    private final Supplier<DirectBufferCache> bufferCache;
    private final Supplier<ByteBufferPool> websocketsBufferPool;
    private final Supplier<XnioWorker> websocketsWorker;
    private final boolean allowNonStandardWrappers;
    private final ServletStackTraces stackTraces;
    private final SessionCookieConfig sessionCookieConfig;
    private final JSPConfig jspConfig;
    private final String defaultEncoding;
    private final boolean useListenerEncoding;
    private final boolean ignoreFlush;
    private final boolean eagerFilterInit;
    private final int defaultSessionTimeout;
    private final boolean disableCachingForSecuredPages;
    private final Boolean directoryListingEnabled;
    private final int sessionIdLength;
    private final CrawlerSessionManagerConfig crawlerSessionManagerConfig;
    private final boolean websocketsEnabled;
    private final boolean dispatchWebsocketInvocationToWorker;
    private final boolean perMessageDeflate;
    private final int deflaterLevel;
    private final Map<String, String> mimeMappings;
    private final List<String> welcomeFiles;
    private final boolean proactiveAuth;
    private final Integer maxSessions;
    private final boolean disableFileWatchService;
    private final boolean disableSessionIdReuse;
    private final int fileCacheMetadataSize;
    private final int fileCacheMaxFileSize;
    private final Integer fileCacheTimeToLive;
    private final int defaultCookieVersion;
    private boolean preservePathOnForward;
    private volatile ServletContainer servletContainer;

    public ServletContainerService(Consumer<ServletContainerService> serviceConsumer, Supplier<SessionPersistenceManager> sessionPersistenceManager, Supplier<DirectBufferCache> bufferCache, Supplier<ByteBufferPool> websocketsBufferPool, Supplier<XnioWorker> websocketsWorker, boolean allowNonStandardWrappers, ServletStackTraces stackTraces, SessionCookieConfig sessionCookieConfig, JSPConfig jspConfig, String defaultEncoding, boolean useListenerEncoding, boolean ignoreFlush, boolean eagerFilterInit, int defaultSessionTimeout, boolean disableCachingForSecuredPages, boolean websocketsEnabled, boolean dispatchWebsocketInvocationToWorker, boolean perMessageDeflate, int deflaterLevel, Map<String, String> mimeMappings, List<String> welcomeFiles, Boolean directoryListingEnabled, boolean proactiveAuth, int sessionIdLength, Integer maxSessions, CrawlerSessionManagerConfig crawlerSessionManagerConfig, boolean disableFileWatchService, boolean disableSessionIdReuse, int fileCacheMetadataSize, int fileCacheMaxFileSize, Integer fileCacheTimeToLive, int defaultCookieVersion, boolean preservePathOnForward) {
        this.serviceConsumer = serviceConsumer;
        this.sessionPersistenceManager = sessionPersistenceManager;
        this.bufferCache = bufferCache;
        this.websocketsBufferPool = websocketsBufferPool;
        this.websocketsWorker = websocketsWorker;
        this.allowNonStandardWrappers = allowNonStandardWrappers;
        this.stackTraces = stackTraces;
        this.sessionCookieConfig = sessionCookieConfig;
        this.jspConfig = jspConfig;
        this.defaultEncoding = defaultEncoding;
        this.useListenerEncoding = useListenerEncoding;
        this.ignoreFlush = ignoreFlush;
        this.eagerFilterInit = eagerFilterInit;
        this.defaultSessionTimeout = defaultSessionTimeout;
        this.disableCachingForSecuredPages = disableCachingForSecuredPages;
        this.websocketsEnabled = websocketsEnabled;
        this.dispatchWebsocketInvocationToWorker = dispatchWebsocketInvocationToWorker;
        this.perMessageDeflate = perMessageDeflate;
        this.deflaterLevel = deflaterLevel;
        this.directoryListingEnabled = directoryListingEnabled;
        this.proactiveAuth = proactiveAuth;
        this.maxSessions = maxSessions;
        this.crawlerSessionManagerConfig = crawlerSessionManagerConfig;
        this.disableFileWatchService = disableFileWatchService;
        this.welcomeFiles = new ArrayList<String>(welcomeFiles);
        this.mimeMappings = new HashMap<String, String>(mimeMappings);
        this.sessionIdLength = sessionIdLength;
        this.disableSessionIdReuse = disableSessionIdReuse;
        this.fileCacheMetadataSize = fileCacheMetadataSize;
        this.fileCacheMaxFileSize = fileCacheMaxFileSize;
        this.fileCacheTimeToLive = fileCacheTimeToLive;
        this.defaultCookieVersion = defaultCookieVersion;
        this.preservePathOnForward = preservePathOnForward;
    }

    public void start(StartContext context) {
        this.servletContainer = ServletContainer.Factory.newInstance();
        this.serviceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.serviceConsumer.accept(null);
    }

    public ServletContainerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    public boolean isAllowNonStandardWrappers() {
        return this.allowNonStandardWrappers;
    }

    public JSPConfig getJspConfig() {
        return this.jspConfig;
    }

    public ServletStackTraces getStackTraces() {
        return this.stackTraces;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    public DirectBufferCache getBufferCache() {
        return this.bufferCache != null ? this.bufferCache.get() : null;
    }

    public boolean isDisableCachingForSecuredPages() {
        return this.disableCachingForSecuredPages;
    }

    public boolean isDispatchWebsocketInvocationToWorker() {
        return this.dispatchWebsocketInvocationToWorker;
    }

    public boolean isPerMessageDeflate() {
        return this.perMessageDeflate;
    }

    public int getDeflaterLevel() {
        return this.deflaterLevel;
    }

    public boolean isWebsocketsEnabled() {
        return this.websocketsEnabled;
    }

    public boolean isDisableSessionIdReuse() {
        return this.disableSessionIdReuse;
    }

    public SessionPersistenceManager getSessionPersistenceManager() {
        return this.sessionPersistenceManager != null ? this.sessionPersistenceManager.get() : null;
    }

    public XnioWorker getWebsocketsWorker() {
        return this.websocketsWorker != null ? this.websocketsWorker.get() : null;
    }

    public ByteBufferPool getWebsocketsBufferPool() {
        return this.websocketsBufferPool != null ? this.websocketsBufferPool.get() : null;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public boolean isUseListenerEncoding() {
        return this.useListenerEncoding;
    }

    public boolean isIgnoreFlush() {
        return this.ignoreFlush;
    }

    public boolean isEagerFilterInit() {
        return this.eagerFilterInit;
    }

    public int getDefaultSessionTimeout() {
        return this.defaultSessionTimeout;
    }

    public Map<String, String> getMimeMappings() {
        return Collections.unmodifiableMap(this.mimeMappings);
    }

    public List<String> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public Boolean getDirectoryListingEnabled() {
        return this.directoryListingEnabled;
    }

    public boolean isProactiveAuth() {
        return this.proactiveAuth;
    }

    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    public Integer getMaxSessions() {
        return this.maxSessions;
    }

    public boolean isDisableFileWatchService() {
        return this.disableFileWatchService;
    }

    public CrawlerSessionManagerConfig getCrawlerSessionManagerConfig() {
        return this.crawlerSessionManagerConfig;
    }

    public int getFileCacheMetadataSize() {
        return this.fileCacheMetadataSize;
    }

    public int getFileCacheMaxFileSize() {
        return this.fileCacheMaxFileSize;
    }

    public Integer getFileCacheTimeToLive() {
        return this.fileCacheTimeToLive;
    }

    public int getDefaultCookieVersion() {
        return this.defaultCookieVersion;
    }

    public boolean isPreservePathOnForward() {
        return this.preservePathOnForward;
    }
}

