/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cxf.Bus;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.jboss.wsf.stack.cxf.client.configuration.MapToBeanConverter;

public class FeatureUtils {
    public static void addFeatures(InterceptorProvider interceptorProvider, Bus bus, Map<String, String> properties) {
        String features = properties.get("cxf.features");
        if (features != null) {
            MapToBeanConverter converter = new MapToBeanConverter(properties);
            for (Feature f : FeatureUtils.createFeatures(features, converter)) {
                f.initialize(interceptorProvider, bus);
            }
        }
    }

    private static List<Feature> createFeatures(String propValue, MapToBeanConverter converter) {
        ArrayList<Feature> list = new ArrayList<Feature>();
        StringTokenizer st = new StringTokenizer(propValue, ", ", false);
        while (st.hasMoreTokens()) {
            Feature feature = (Feature)FeatureUtils.newInstance(st.nextToken(), converter);
            if (feature == null) continue;
            list.add(feature);
        }
        return list;
    }

    private static Object newInstance(String className, MapToBeanConverter converter) {
        try {
            return className.startsWith("##") ? converter.get(className) : converter.newInstance(className);
        }
        catch (Exception e) {
            return null;
        }
    }
}

