/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;

public final class AsyncJms2ProducerFacade {
    private final long id;
    protected final Session session;
    private final MessageProducer producer;
    private long pending;
    private final long maxPending;
    private final long transactionCapacity;
    private long pendingMsgInTransaction;
    private long completedMsgInTransaction;
    private final List<Runnable> availableObservers;
    private final List<Runnable> closedObservers;
    private static final AtomicLongFieldUpdater<AsyncJms2ProducerFacade> MESSAGE_SENT_UPDATER = AtomicLongFieldUpdater.newUpdater(AsyncJms2ProducerFacade.class, "messageSent");
    private static final AtomicLongFieldUpdater<AsyncJms2ProducerFacade> MESSAGE_COMPLETED_UPDATER = AtomicLongFieldUpdater.newUpdater(AsyncJms2ProducerFacade.class, "messageCompleted");
    private static final AtomicLongFieldUpdater<AsyncJms2ProducerFacade> NOT_AVAILABLE_UPDATER = AtomicLongFieldUpdater.newUpdater(AsyncJms2ProducerFacade.class, "notAvailable");
    private volatile long messageSent;
    private volatile long messageCompleted;
    private volatile long notAvailable;
    private boolean closing;
    private boolean closed;
    private final Destination destination;

    public AsyncJms2ProducerFacade(long id, Session session, MessageProducer producer, Destination destination, long maxPending, long transactionCapacity) {
        this.id = id;
        this.session = Objects.requireNonNull(session);
        this.producer = Objects.requireNonNull(producer);
        this.destination = destination;
        this.pending = 0L;
        this.maxPending = transactionCapacity > 0L && maxPending > 0L ? Math.max(maxPending, transactionCapacity) : maxPending;
        this.availableObservers = new ArrayList<Runnable>(1);
        this.closedObservers = new ArrayList<Runnable>(1);
        this.messageSent = 0L;
        this.messageCompleted = 0L;
        this.notAvailable = 0L;
        try {
            if (transactionCapacity < 0L) {
                throw new IllegalStateException("transactionCapacity must be >= 0");
            }
            if (transactionCapacity > 0L) {
                if (!session.getTransacted()) {
                    throw new IllegalStateException("session must be transacted with transactionCapacity != 0");
                }
            } else if (session.getTransacted()) {
                throw new IllegalStateException("session cannot be transacted with transactionCapacity = 0");
            }
        }
        catch (JMSException ex) {
            throw new IllegalStateException(ex);
        }
        this.transactionCapacity = transactionCapacity;
        this.pendingMsgInTransaction = 0L;
        this.completedMsgInTransaction = 0L;
        this.closing = false;
        this.closed = false;
    }

    public long getId() {
        return this.id;
    }

    public Destination getDestination() {
        return this.destination;
    }

    BytesMessage createBytesMessage() throws JMSException {
        return this.session.createBytesMessage();
    }

    private void addedPendingSend() {
        if (this.transactionCapacity > 0L && this.pendingMsgInTransaction == this.transactionCapacity) {
            throw new IllegalStateException("reached max in-flight transacted sent messages");
        }
        if (this.maxPending > 0L && this.pending == this.maxPending) {
            throw new IllegalStateException("reached max in-flight sent messages");
        }
        ++this.pending;
        ++this.pendingMsgInTransaction;
    }

    private boolean isAvailable() {
        if (this.maxPending > 0L && this.pending == this.maxPending) {
            return false;
        }
        return this.transactionCapacity == 0L || this.pendingMsgInTransaction != this.transactionCapacity;
    }

    public SendAttemptResult trySend(Message message, CompletionListener completionListener, Runnable availableObserver) throws JMSException {
        if (this.closing) {
            return SendAttemptResult.Closing;
        }
        if (this.closed) {
            return SendAttemptResult.Closed;
        }
        if (!this.isAvailable()) {
            this.availableObservers.add(availableObserver);
            this.orderedIncrementNotAvailable();
            return SendAttemptResult.NotAvailable;
        }
        this.producer.send(message, completionListener);
        this.orderedIncrementSent();
        this.addedPendingSend();
        return SendAttemptResult.Success;
    }

    public void onSendErrored() {
        if (this.closed) {
            return;
        }
        this.availableObservers.clear();
        this.closedObservers.forEach(Runnable::run);
        this.closedObservers.clear();
        this.closed = true;
    }

    public JMSException onSendCompleted() {
        if (this.closed) {
            return null;
        }
        JMSException completionError = null;
        this.orderedIncrementCompleted();
        if (this.transactionCapacity > 0L && this.completedMsgInTransaction == this.transactionCapacity) {
            throw new IllegalStateException("cannot complete more send");
        }
        if (this.pending == 0L) {
            throw new IllegalStateException("cannot complete more send");
        }
        --this.pending;
        ++this.completedMsgInTransaction;
        if (this.transactionCapacity > 0L) {
            if (this.completedMsgInTransaction == this.transactionCapacity || this.closing && this.pending == 0L) {
                this.completedMsgInTransaction = 0L;
                this.pendingMsgInTransaction = 0L;
                try {
                    this.session.commit();
                }
                catch (JMSException fatal) {
                    completionError = fatal;
                    this.closing = true;
                }
                if (this.closing) {
                    this.closing = false;
                    this.closed = true;
                    this.closedObservers.forEach(Runnable::run);
                    this.closedObservers.clear();
                } else if (this.isAvailable()) {
                    this.availableObservers.forEach(Runnable::run);
                    this.availableObservers.clear();
                }
            }
        } else if (this.closing && this.pending == 0L) {
            this.closing = false;
            this.closed = true;
            this.closedObservers.forEach(Runnable::run);
            this.closedObservers.clear();
        } else if (this.isAvailable()) {
            this.availableObservers.forEach(Runnable::run);
            this.availableObservers.clear();
        }
        return completionError;
    }

    public long getMessageSent() {
        return this.messageSent;
    }

    private void orderedIncrementSent() {
        MESSAGE_SENT_UPDATER.lazySet(this, this.messageSent + 1L);
    }

    public long getMessageCompleted() {
        return this.messageCompleted;
    }

    private void orderedIncrementCompleted() {
        MESSAGE_COMPLETED_UPDATER.lazySet(this, this.messageCompleted + 1L);
    }

    public long getNotAvailable() {
        return this.notAvailable;
    }

    private void orderedIncrementNotAvailable() {
        NOT_AVAILABLE_UPDATER.lazySet(this, this.notAvailable + 1L);
    }

    public void requestClose() {
        this.requestClose(() -> {});
    }

    public void requestClose(Runnable onClosed) {
        if (this.closed) {
            onClosed.run();
            return;
        }
        if (this.closing) {
            this.closedObservers.add(onClosed);
            return;
        }
        this.availableObservers.clear();
        if (this.pending > 0L) {
            this.closing = true;
            this.closedObservers.add(onClosed);
        } else {
            this.closed = true;
            onClosed.run();
        }
    }

    public static enum SendAttemptResult {
        Closing,
        Closed,
        NotAvailable,
        Success;

    }
}

