/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.faces.component;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.wildfly.clustering.marshalling.protostream.EnumMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshallerProvider;
import org.wildfly.clustering.marshalling.protostream.reflect.FieldMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum ComponentMarshallerProvider implements ProtoStreamMarshallerProvider
{
    PROPERTY_KEYS(UIComponent.class, "PropertyKeys"),
    PROPERTY_KEYS_PRIVATE(UIComponent.class, "PropertyKeysPrivate"),
    STATE_HOLDER_SAVER("javax.faces.component.StateHolderSaver");

    private final ProtoStreamMarshaller<?> marshaller;

    private ComponentMarshallerProvider(Class<?> parentClass, String enumName) {
        try {
            this.marshaller = new EnumMarshaller(WildFlySecurityManager.getClassLoaderPrivileged(parentClass).loadClass(parentClass.getName() + "$" + enumName).asSubclass(Enum.class));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private ComponentMarshallerProvider(String className) {
        try {
            Class<?> targetClass = WildFlySecurityManager.getClassLoaderPrivileged(StateHolder.class).loadClass(className);
            PrivilegedAction<Object> action = () -> {
                try {
                    Constructor constructor = targetClass.getDeclaredConstructor(FacesContext.class, Object.class);
                    constructor.setAccessible(true);
                    return constructor.newInstance(null, null);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            };
            this.marshaller = new FieldMarshaller(targetClass, () -> WildFlySecurityManager.doUnchecked((PrivilegedAction)action), new Class[]{String.class, Serializable.class});
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private ComponentMarshallerProvider(ProtoStreamMarshaller<?> marshaller) {
        this.marshaller = marshaller;
    }

    public ProtoStreamMarshaller<?> getMarshaller() {
        return this.marshaller;
    }
}

