/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewManagedReferenceFactory;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.RemoteViewManagedReferenceFactory;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Value;

public class EjbInjectionSource
extends InjectionSource {
    private final String beanName;
    private final String typeName;
    private final String bindingName;
    private final DeploymentUnit deploymentUnit;
    private final boolean appclient;
    private volatile String error = null;
    private volatile ServiceName resolvedViewName;
    private volatile RemoteViewManagedReferenceFactory remoteFactory;
    private volatile boolean resolved = false;

    public EjbInjectionSource(String beanName, String typeName, String bindingName, DeploymentUnit deploymentUnit, boolean appclient) {
        this.beanName = beanName;
        this.typeName = typeName;
        this.bindingName = bindingName;
        this.deploymentUnit = deploymentUnit;
        this.appclient = appclient;
    }

    public EjbInjectionSource(String typeName, String bindingName, DeploymentUnit deploymentUnit, boolean appclient) {
        this.bindingName = bindingName;
        this.deploymentUnit = deploymentUnit;
        this.appclient = appclient;
        this.beanName = null;
        this.typeName = typeName;
    }

    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        this.resolve();
        if (this.error != null) {
            throw new DeploymentUnitProcessingException(this.error);
        }
        if (this.remoteFactory != null) {
            injector.inject((Object)this.remoteFactory);
        } else if (!this.appclient) {
            serviceBuilder.addDependency(this.resolvedViewName, ComponentView.class, (Injector)new ViewManagedReferenceFactory.Injector(injector));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (!this.resolved) {
            EjbInjectionSource ejbInjectionSource = this;
            synchronized (ejbInjectionSource) {
                if (!this.resolved) {
                    Set<ViewDescription> views = this.getViews();
                    HashSet<EJBViewDescription> ejbsForViewName = new HashSet<EJBViewDescription>();
                    for (ViewDescription view : views) {
                        MethodInterfaceType viewType;
                        if (!(view instanceof EJBViewDescription) || (viewType = ((EJBViewDescription)view).getMethodIntf()) == MethodInterfaceType.ServiceEndpoint || viewType == MethodInterfaceType.MessageEndpoint) continue;
                        ejbsForViewName.add((EJBViewDescription)view);
                    }
                    if (ejbsForViewName.isEmpty()) {
                        this.error = this.beanName == null ? EjbLogger.ROOT_LOGGER.ejbNotFound(this.typeName, this.bindingName) : EjbLogger.ROOT_LOGGER.ejbNotFound(this.typeName, this.beanName, this.bindingName);
                    } else if (ejbsForViewName.size() > 1) {
                        this.error = this.beanName == null ? EjbLogger.ROOT_LOGGER.moreThanOneEjbFound(this.typeName, this.bindingName, ejbsForViewName) : EjbLogger.ROOT_LOGGER.moreThanOneEjbFound(this.typeName, this.beanName, this.bindingName, ejbsForViewName);
                    } else {
                        ServiceName serviceName;
                        EJBViewDescription description = (EJBViewDescription)((Object)ejbsForViewName.iterator().next());
                        EJBViewDescription ejbViewDescription = description;
                        if (ejbViewDescription.getMethodIntf() == MethodInterfaceType.Remote || ejbViewDescription.getMethodIntf() == MethodInterfaceType.Home) {
                            EJBComponentDescription componentDescription = description.getComponentDescription();
                            EEModuleDescription moduleDescription = componentDescription.getModuleDescription();
                            String earApplicationName = moduleDescription.getEarApplicationName();
                            Value<ClassLoader> viewClassLoader = new Value<ClassLoader>(){

                                public ClassLoader getValue() throws IllegalStateException, IllegalArgumentException {
                                    Module module = (Module)EjbInjectionSource.this.deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
                                    return module != null ? module.getClassLoader() : null;
                                }
                            };
                            this.remoteFactory = new RemoteViewManagedReferenceFactory(earApplicationName, moduleDescription.getModuleName(), moduleDescription.getDistinctName(), componentDescription.getComponentName(), description.getViewClassName(), componentDescription.isStateful(), viewClassLoader, this.appclient);
                        }
                        this.resolvedViewName = serviceName = description.getServiceName();
                    }
                    this.resolved = true;
                }
            }
        }
    }

    private Set<ViewDescription> getViews() {
        EEApplicationDescription applicationDescription = (EEApplicationDescription)this.deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        ResourceRoot deploymentRoot = (ResourceRoot)this.deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        Set componentsForViewName = this.beanName != null ? applicationDescription.getComponents(this.beanName, this.typeName, deploymentRoot.getRoot()) : applicationDescription.getComponentsForViewName(this.typeName, deploymentRoot.getRoot());
        return componentsForViewName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EjbInjectionSource)) {
            return false;
        }
        this.resolve();
        if (this.error != null) {
            return false;
        }
        EjbInjectionSource other = (EjbInjectionSource)((Object)o);
        return EjbInjectionSource.eq(this.typeName, other.typeName) && EjbInjectionSource.eq(this.resolvedViewName, other.resolvedViewName);
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }

    private static boolean eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

