/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.routing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.distribution.CacheKeyDistribution;
import org.wildfly.clustering.infinispan.distribution.KeyDistribution;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.server.NodeFactory;
import org.wildfly.clustering.web.infinispan.routing.RankedRouteLocatorConfiguration;
import org.wildfly.clustering.web.routing.RouteLocator;

public class RankedRouteLocator
implements RouteLocator {
    private final KeyDistribution distribution;
    private final Registry<String, Void> registry;
    private final NodeFactory<Address> factory;
    private final String localRoute;
    private final String delimiter;
    private final int maxRoutes;

    public RankedRouteLocator(RankedRouteLocatorConfiguration config) {
        this(config.getCache(), config.getRegistry(), config.getMemberFactory(), config.getDelimiter(), config.getMaxRoutes());
    }

    private RankedRouteLocator(Cache<GroupedKey<String>, ?> cache, Registry<String, Void> registry, NodeFactory<Address> factory, String delimiter, int maxRoutes) {
        this((KeyDistribution)new CacheKeyDistribution(cache), registry, factory, delimiter, maxRoutes);
    }

    RankedRouteLocator(KeyDistribution distribution, Registry<String, Void> registry, NodeFactory<Address> factory, String delimiter, int maxRoutes) {
        this.distribution = distribution;
        this.registry = registry;
        this.factory = factory;
        this.localRoute = (String)this.registry.getEntry(this.registry.getGroup().getLocalMember()).getKey();
        this.delimiter = delimiter;
        this.maxRoutes = maxRoutes;
    }

    public String locate(String sessionId) {
        List owners = this.distribution.getOwners((Object)new GroupedKey((Object)sessionId));
        ArrayList<String> routes = new ArrayList<String>(this.maxRoutes);
        boolean localIsOwner = false;
        Node localMember = this.registry.getGroup().getLocalMember();
        Iterator addresses = owners.iterator();
        while (addresses.hasNext() && routes.size() < this.maxRoutes) {
            Map.Entry entry;
            Address address = (Address)addresses.next();
            Node member = this.factory.createNode((Object)address);
            if (member.equals(localMember)) {
                localIsOwner = true;
            }
            if ((entry = this.registry.getEntry(member)) == null) continue;
            routes.add((String)entry.getKey());
        }
        if (!localIsOwner && routes.size() < this.maxRoutes) {
            routes.add(this.localRoute);
        }
        return !routes.isEmpty() ? String.join((CharSequence)this.delimiter, routes) : this.localRoute;
    }
}

