/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.logmanager;

import org.jboss.as.logging.logmanager.WildFlyLogContextSelector;
import org.jboss.logmanager.ClassLoaderLogContextSelector;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;

class WildFlyLogContextSelectorImpl
implements WildFlyLogContextSelector {
    private final LogContextSelector defaultLogContextSelector;
    private final ClassLoaderLogContextSelector contextSelector;
    private final ThreadLocal<LogContext> localContext = new ThreadLocal();
    private int counter;
    private int dftCounter;

    WildFlyLogContextSelectorImpl(LogContext defaultLogContext) {
        this(() -> defaultLogContext);
    }

    WildFlyLogContextSelectorImpl(LogContextSelector defaultLogContextSelector) {
        LogContextSelector dft = defaultLogContextSelector instanceof WildFlyLogContextSelectorImpl ? ((WildFlyLogContextSelectorImpl)defaultLogContextSelector).defaultLogContextSelector : defaultLogContextSelector;
        this.defaultLogContextSelector = dft;
        this.counter = 0;
        this.dftCounter = 0;
        this.contextSelector = new ClassLoaderLogContextSelector(dft, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogContext getLogContext() {
        int counter;
        LogContext localContext = this.localContext.get();
        if (localContext != null) {
            return localContext;
        }
        WildFlyLogContextSelectorImpl wildFlyLogContextSelectorImpl = this;
        synchronized (wildFlyLogContextSelectorImpl) {
            counter = this.counter;
        }
        return counter > 0 ? this.contextSelector.getLogContext() : this.defaultLogContextSelector.getLogContext();
    }

    @Override
    public LogContext setLocalContext(LogContext newValue) {
        try {
            LogContext logContext = this.localContext.get();
            return logContext;
        }
        finally {
            if (newValue == null) {
                this.localContext.remove();
            } else {
                this.localContext.set(newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLogContext(ClassLoader classLoader, LogContext logContext) {
        this.contextSelector.registerLogContext(classLoader, logContext);
        WildFlyLogContextSelectorImpl wildFlyLogContextSelectorImpl = this;
        synchronized (wildFlyLogContextSelectorImpl) {
            if (this.counter > 0) {
                ++this.counter;
            } else if (logContext != this.defaultLogContextSelector.getLogContext()) {
                this.counter = this.dftCounter + 1;
                this.dftCounter = 0;
            } else {
                ++this.dftCounter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregisterLogContext(ClassLoader classLoader, LogContext logContext) {
        if (this.contextSelector.unregisterLogContext(classLoader, logContext)) {
            WildFlyLogContextSelectorImpl wildFlyLogContextSelectorImpl = this;
            synchronized (wildFlyLogContextSelectorImpl) {
                if (this.counter > 0) {
                    --this.counter;
                } else if (this.dftCounter > 0) {
                    --this.dftCounter;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addLogApiClassLoader(ClassLoader apiClassLoader) {
        return this.contextSelector.addLogApiClassLoader(apiClassLoader);
    }

    @Override
    public boolean removeLogApiClassLoader(ClassLoader apiClassLoader) {
        return this.contextSelector.removeLogApiClassLoader(apiClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registeredCount() {
        WildFlyLogContextSelectorImpl wildFlyLogContextSelectorImpl = this;
        synchronized (wildFlyLogContextSelectorImpl) {
            return this.counter;
        }
    }
}

