/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.MarshalledValue;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodStoreConfiguration;
import org.reactivestreams.Publisher;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.common.function.Functions;

@ConfiguredBy(value=HotRodStoreConfiguration.class)
public class HotRodStore<K, V>
implements NonBlockingStore<K, V> {
    private static final Set<NonBlockingStore.Characteristic> CHARACTERISTICS = EnumSet.of(NonBlockingStore.Characteristic.SHAREABLE, NonBlockingStore.Characteristic.BULK_READ, NonBlockingStore.Characteristic.EXPIRATION);
    private RemoteCache<ByteBuffer, ByteBuffer> cache;
    private BlockingManager blockingManager;
    private OperationsFactory operationsFactory;
    private PersistenceMarshaller marshaller;
    private MarshallableEntryFactory<K, V> entryFactory;
    private int batchSize;

    public CompletionStage<Void> start(InitializationContext context) {
        this.blockingManager = context.getBlockingManager();
        HotRodStoreConfiguration configuration = (HotRodStoreConfiguration)context.getConfiguration();
        final RemoteCacheContainer container = configuration.remoteCacheContainer();
        String cacheConfiguration = configuration.cacheConfiguration();
        final String cacheName = context.getCache().getName();
        this.batchSize = configuration.maxBatchSize();
        this.marshaller = context.getPersistenceMarshaller();
        this.entryFactory = context.getMarshallableEntryFactory();
        final String templateName = cacheConfiguration != null ? cacheConfiguration : DefaultTemplate.DIST_SYNC.getTemplateName();
        Consumer<RemoteCacheConfigurationBuilder> configurator = new Consumer<RemoteCacheConfigurationBuilder>(){

            @Override
            public void accept(RemoteCacheConfigurationBuilder builder) {
                builder.forceReturnValues(false).transactionMode(TransactionMode.NONE).nearCacheMode(NearCacheMode.DISABLED).templateName(templateName);
            }
        };
        container.getConfiguration().addRemoteCache(cacheName, (Consumer)configurator);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    HotRodStore.this.setRemoteCache(container, cacheName);
                }
                catch (HotRodClientException ex) {
                    throw new PersistenceException((Throwable)ex);
                }
            }
        };
        return this.blockingManager.runBlocking(task, (Object)"hotrod-store-start");
    }

    synchronized void setRemoteCache(RemoteCacheContainer container, String cacheName) {
        this.cache = container.getCache(cacheName);
        if (this.cache == null) {
            throw InfinispanLogger.ROOT_LOGGER.remoteCacheMustBeDefined(container.getConfiguration().version().toString(), cacheName);
        }
        RemoteCacheManager manager = this.cache.getRemoteCacheManager();
        this.operationsFactory = new OperationsFactory(manager.getChannelFactory(), manager.getCodec(), null, manager.getConfiguration());
        this.cache.start();
    }

    public CompletionStage<Void> stop() {
        return this.cache != null ? this.blockingManager.runBlocking(() -> this.cache.stop(), (Object)"hotrod-store-stop") : CompletableFutures.completedNull();
    }

    public Set<NonBlockingStore.Characteristic> characteristics() {
        return CHARACTERISTICS;
    }

    public CompletionStage<MarshallableEntry<K, V>> load(int segment, Object key) {
        try {
            return this.cache.getAsync((Object)this.marshalKey(key)).thenApply(value -> value != null ? this.entryFactory.create(key, this.unmarshalValue((ByteBuffer)value)) : null);
        }
        catch (PersistenceException e) {
            return CompletableFutures.completedExceptionFuture((Throwable)e);
        }
    }

    public CompletionStage<Void> write(int segment, MarshallableEntry<? extends K, ? extends V> entry) {
        try {
            return this.cache.putAsync((Object)entry.getKeyBytes(), (Object)this.marshalValue(entry.getMarshalledValue())).thenAccept(Functions.discardingConsumer());
        }
        catch (PersistenceException e) {
            return CompletableFutures.completedExceptionFuture((Throwable)e);
        }
    }

    public CompletionStage<Boolean> delete(int segment, Object key) {
        try {
            return this.cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).removeAsync((Object)this.marshalKey(key)).thenApply(Objects::nonNull);
        }
        catch (PersistenceException e) {
            return CompletableFutures.completedExceptionFuture((Throwable)e);
        }
    }

    public CompletionStage<Void> batch(int publisherCount, Publisher<NonBlockingStore.SegmentedPublisher<Object>> removePublisher, Publisher<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) {
        Completable removeCompletable = Flowable.fromPublisher(removePublisher).flatMap(sp -> Flowable.fromPublisher((Publisher)sp), publisherCount).flatMapCompletable(key -> Completable.fromCompletionStage((CompletionStage)this.cache.removeAsync((Object)this.marshalKey(key))), false, this.batchSize);
        Completable writeCompletable = Flowable.fromPublisher(writePublisher).flatMap(sp -> Flowable.fromPublisher((Publisher)sp), publisherCount).flatMapCompletable(entry -> Completable.fromCompletionStage((CompletionStage)this.cache.putAsync((Object)entry.getKeyBytes(), (Object)this.marshalValue(entry.getMarshalledValue()))), false, this.batchSize);
        return removeCompletable.mergeWith((CompletableSource)writeCompletable).toCompletionStage(null);
    }

    public Flowable<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        try {
            Stream<Object> keys = this.cache.keySet().stream().map(this::unmarshalKey);
            Stream<Object> filteredKeys = filter != null ? keys.filter(filter) : keys;
            return Flowable.fromPublisher((Publisher)this.blockingManager.blockingPublisher((Publisher)Flowable.defer(() -> Flowable.fromStream((Stream)filteredKeys).doFinally(filteredKeys::close))));
        }
        catch (PersistenceException e) {
            return Flowable.fromCompletionStage((CompletionStage)CompletableFutures.completedExceptionFuture((Throwable)e));
        }
    }

    public Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean includeValues) {
        return includeValues ? this.publishEntries(segments, filter) : this.publishKeys(segments, filter).map(arg_0 -> this.entryFactory.create(arg_0));
    }

    private Flowable<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter) {
        try {
            Stream<MarshallableEntry> entries = this.cache.entrySet().stream().map(this::unmarshalEntry);
            Stream<MarshallableEntry> filteredEntries = filter != null ? entries.filter(entry -> filter.test((Object)entry.getKey())) : entries;
            return Flowable.fromPublisher((Publisher)this.blockingManager.blockingPublisher((Publisher)Flowable.defer(() -> Flowable.fromStream((Stream)filteredEntries).doFinally(filteredEntries::close))));
        }
        catch (PersistenceException e) {
            return Flowable.fromCompletionStage((CompletionStage)CompletableFutures.completedExceptionFuture((Throwable)e));
        }
    }

    public CompletionStage<Void> clear() {
        return this.cache.clearAsync();
    }

    public CompletionStage<Boolean> containsKey(int segment, Object key) {
        try {
            return this.cache.containsKeyAsync((Object)this.marshalKey(key));
        }
        catch (PersistenceException e) {
            return CompletableFutures.completedExceptionFuture((Throwable)e);
        }
    }

    public CompletionStage<Boolean> isAvailable() {
        return this.operationsFactory.newFaultTolerantPingOperation().execute().thenApply(PingResponse::isSuccess);
    }

    public CompletionStage<Long> size(IntSet segments) {
        return this.cache.sizeAsync();
    }

    private ByteBuffer marshalKey(Object key) {
        return this.entryFactory.create(key).getKeyBytes();
    }

    private K unmarshalKey(ByteBuffer key) {
        try {
            return (K)this.marshaller.objectFromByteBuffer(key.getBuf(), key.getOffset(), key.getLength());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private MarshallableEntry<K, V> unmarshalEntry(Map.Entry<ByteBuffer, ByteBuffer> entry) {
        return this.entryFactory.create(this.unmarshalKey(entry.getKey()), this.unmarshalValue(entry.getValue()));
    }

    private ByteBuffer marshalValue(MarshalledValue value) {
        try {
            return this.marshaller.objectToBuffer((Object)value);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PersistenceException((Throwable)e);
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private MarshalledValue unmarshalValue(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        try {
            return (MarshalledValue)this.marshaller.objectFromByteBuffer(buffer.getBuf(), buffer.getOffset(), buffer.getLength());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

