/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.jboss.resteasy.plugins.server.servlet.ListenerBootstrap;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class ServletBootstrap
extends ListenerBootstrap {
    private final ServletConfig config;

    public ServletBootstrap(ServletConfig config) {
        super(config.getServletContext());
        this.config = config;
    }

    @Override
    public ResteasyDeployment createDeployment() {
        ResteasyDeployment deployment = super.createDeployment();
        deployment.getDefaultContextObjects().put(ServletConfig.class, this.config);
        deployment.getDefaultContextObjects().put(ServletContext.class, this.config.getServletContext());
        return deployment;
    }

    @Override
    public String getInitParameter(String name) {
        String value = this.config.getInitParameter(name);
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    @Override
    public Set<String> getParameterNames() {
        Set<String> set = super.getServletContextNames();
        Enumeration en = this.config.getInitParameterNames();
        while (en.hasMoreElements()) {
            set.add((String)en.nextElement());
        }
        return set;
    }

    @Override
    public Set<String> getInitParameterNames() {
        HashSet<String> set = new HashSet<String>();
        Enumeration en = this.config.getInitParameterNames();
        while (en.hasMoreElements()) {
            set.add((String)en.nextElement());
        }
        return set;
    }
}

