/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Decorated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bean.builtin.InterceptedBeanMetadataBean;
import org.jboss.weld.contexts.WeldCreationalContext;
import org.jboss.weld.literal.DecoratedLiteral;
import org.jboss.weld.logging.InterceptorLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.bean.SerializableForwardingBean;

public class DecoratedBeanMetadataBean
extends InterceptedBeanMetadataBean {
    public DecoratedBeanMetadataBean(BeanManagerImpl beanManager) {
        super(new StringBeanIdentifier(BeanIdentifiers.forBuiltInBean(beanManager, Bean.class, Decorated.class.getSimpleName())), beanManager);
    }

    @Override
    protected void checkInjectionPoint(InjectionPoint ip) {
        if (!(ip.getBean() instanceof Decorator)) {
            throw new IllegalArgumentException("@Decorated Bean<?> can only be injected into a decorator.");
        }
    }

    @Override
    protected Bean<?> newInstance(InjectionPoint ip, CreationalContext<Bean<?>> ctx) {
        this.checkInjectionPoint(ip);
        WeldCreationalContext<Bean<?>> decoratorContext = this.getParentCreationalContext(ctx);
        WeldCreationalContext<Bean<?>> beanContext = this.getParentCreationalContext((CreationalContext<?>)decoratorContext);
        while (beanContext.getContextual() instanceof Decorator) {
            beanContext = this.getParentCreationalContext((CreationalContext<?>)beanContext);
        }
        Contextual<Bean<?>> decoratedContextual = beanContext.getContextual();
        if (decoratedContextual instanceof Bean) {
            Bean bean = (Bean)decoratedContextual;
            if (bean instanceof Serializable) {
                return bean;
            }
            return SerializableForwardingBean.of(this.getBeanManager().getContextId(), bean);
        }
        InterceptorLogger.LOG.unableToDetermineInterceptedBean(ip);
        return null;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return Collections.singleton(DecoratedLiteral.INSTANCE);
    }

    @Override
    public String toString() {
        return "Implicit Bean [javax.enterprise.inject.spi.Bean] with qualifiers [@Decorated]";
    }
}

