/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.domain;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Objects;
import org.glassfish.soteria.Utils;

public class OpenIdNonce
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BYTE_LENGTH = 32;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final String value;

    public OpenIdNonce() {
        this(32);
    }

    public OpenIdNonce(String value) {
        if (Utils.isEmpty(value)) {
            throw new IllegalArgumentException("The nonce value can't be null or empty");
        }
        this.value = value;
    }

    public OpenIdNonce(int byteLength) {
        if (byteLength < 1) {
            throw new IllegalArgumentException("The byte length value must be greater than one");
        }
        byte[] array = new byte[byteLength];
        SECURE_RANDOM.nextBytes(array);
        this.value = new String(Base64.getUrlEncoder().withoutPadding().encode(array), StandardCharsets.UTF_8);
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (Objects.isNull(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenIdNonce other = (OpenIdNonce)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return this.getValue();
    }
}

