/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import jakarta.transaction.Synchronization;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSession;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;

public class HibernateOrmSearchSessionHolder
implements Serializable {
    private static final String SESSION_PROPERTY_KEY = "hibernate.search.session";
    private static final Map<Transaction, HibernateOrmSearchSessionHolder> holderPerClosedSessionTransaction = new ConcurrentHashMap<Transaction, HibernateOrmSearchSessionHolder>();
    private transient HibernateOrmSearchSession searchSession;
    private transient Map<Transaction, PojoIndexingPlan> planPerTransaction;

    public static int staticMapSize() {
        return holderPerClosedSessionTransaction.size();
    }

    public static HibernateOrmSearchSessionHolder get(SessionImplementor session, boolean createIfMissing) {
        boolean closedSessionAndTransaction;
        HibernateOrmSearchSessionHolder holder = (HibernateOrmSearchSessionHolder)session.getProperties().get(SESSION_PROPERTY_KEY);
        if (holder != null) {
            return holder;
        }
        boolean bl = closedSessionAndTransaction = session.isClosed() && session.isTransactionInProgress();
        if (closedSessionAndTransaction) {
            holder = holderPerClosedSessionTransaction.get(session.accessTransaction());
        }
        if (holder != null) {
            return holder;
        }
        if (!createIfMissing) {
            return null;
        }
        holder = new HibernateOrmSearchSessionHolder();
        if (closedSessionAndTransaction) {
            Transaction transaction = session.accessTransaction();
            transaction.registerSynchronization((Synchronization)new HolderPerClosedSessionTransactionCleanup(transaction));
            holderPerClosedSessionTransaction.put(transaction, holder);
        } else {
            session.setProperty(SESSION_PROPERTY_KEY, (Object)holder);
        }
        return holder;
    }

    public HibernateOrmSearchSession searchSession() {
        return this.searchSession;
    }

    public void searchSession(HibernateOrmSearchSession searchSession) {
        this.searchSession = searchSession;
    }

    public PojoIndexingPlan pojoIndexingPlan(Transaction transaction) {
        return this.planPerTransaction == null ? null : this.planPerTransaction.get(transaction);
    }

    public void pojoIndexingPlan(Transaction transaction, PojoIndexingPlan plan) {
        if (this.planPerTransaction == null) {
            this.planPerTransaction = new HashMap<Transaction, PojoIndexingPlan>();
        }
        this.planPerTransaction.put(transaction, plan);
    }

    public void clear(Transaction transactionIdentifier) {
        if (this.planPerTransaction == null) {
            return;
        }
        this.planPerTransaction.remove(transactionIdentifier);
    }

    private static class HolderPerClosedSessionTransactionCleanup
    implements Synchronization {
        private final Transaction transaction;

        public HolderPerClosedSessionTransactionCleanup(Transaction transaction) {
            this.transaction = transaction;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int i) {
            holderPerClosedSessionTransaction.remove(this.transaction);
        }
    }
}

