/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

public abstract class TaxonomyFacets
extends Facets {
    private static final Comparator<FacetResult> BY_VALUE_THEN_DIM = new Comparator<FacetResult>(){

        @Override
        public int compare(FacetResult a, FacetResult b) {
            if (a.value.doubleValue() > b.value.doubleValue()) {
                return -1;
            }
            if (b.value.doubleValue() > a.value.doubleValue()) {
                return 1;
            }
            return a.dim.compareTo(b.dim);
        }
    };
    protected final String indexFieldName;
    protected final TaxonomyReader taxoReader;
    protected final FacetsConfig config;
    private int[] children;
    private int[] siblings;
    protected final int[] parents;

    protected TaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config) throws IOException {
        this.indexFieldName = indexFieldName;
        this.taxoReader = taxoReader;
        this.config = config;
        this.parents = taxoReader.getParallelTaxonomyArrays().parents();
    }

    protected int[] getChildren() throws IOException {
        if (this.children == null) {
            this.children = this.taxoReader.getParallelTaxonomyArrays().children();
        }
        return this.children;
    }

    protected int[] getSiblings() throws IOException {
        if (this.siblings == null) {
            this.siblings = this.taxoReader.getParallelTaxonomyArrays().siblings();
        }
        return this.siblings;
    }

    public boolean childrenLoaded() {
        return this.children != null;
    }

    public boolean siblingsLoaded() {
        return this.children != null;
    }

    protected FacetsConfig.DimConfig verifyDim(String dim) {
        FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
        if (!dimConfig.indexFieldName.equals(this.indexFieldName)) {
            throw new IllegalArgumentException("dimension \"" + dim + "\" was not indexed into field \"" + this.indexFieldName + "\"");
        }
        return dimConfig;
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        int ord = children[0];
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        while (ord != -1) {
            FacetResult result;
            String dim = this.taxoReader.getPath((int)ord).components[0];
            FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
            if (dimConfig.indexFieldName.equals(this.indexFieldName) && (result = this.getTopChildren(topN, dim, new String[0])) != null) {
                results.add(result);
            }
            ord = siblings[ord];
        }
        Collections.sort(results, BY_VALUE_THEN_DIM);
        return results;
    }
}

