/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.concurrent.atomic.LongAdder;
import org.infinispan.container.offheap.OffHeapMemory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class UnpooledOffHeapMemoryAllocator
implements OffHeapMemoryAllocator {
    private static final Log log = LogFactory.getLog(UnpooledOffHeapMemoryAllocator.class, Log.class);
    private static final OffHeapMemory MEMORY = OffHeapMemory.INSTANCE;
    private final LongAdder amountAllocated = new LongAdder();

    @Override
    public long allocate(long memoryLength) {
        long estimatedMemoryLength = UnpooledOffHeapMemoryAllocator.estimateSizeOverhead(memoryLength);
        long memoryLocation = MEMORY.allocate(memoryLength);
        this.amountAllocated.add(estimatedMemoryLength);
        if (log.isTraceEnabled()) {
            log.tracef("Allocated off-heap memory at 0x%016x with %d bytes. Total size: %d", memoryLocation, estimatedMemoryLength, this.amountAllocated.sum());
        }
        return memoryLocation;
    }

    @Override
    public void deallocate(long memoryAddress, long size) {
        long estimatedMemoryLength = UnpooledOffHeapMemoryAllocator.estimateSizeOverhead(size);
        this.innerDeallocate(memoryAddress, estimatedMemoryLength);
    }

    private void innerDeallocate(long memoryAddress, long estimatedSize) {
        this.amountAllocated.add(-estimatedSize);
        if (log.isTraceEnabled()) {
            log.tracef("Deallocating off-heap memory at 0x%016x with %d bytes. Total size: %d", memoryAddress, estimatedSize, this.amountAllocated.sum());
        }
        MEMORY.free(memoryAddress);
    }

    @Override
    public long getAllocatedAmount() {
        return this.amountAllocated.sum();
    }

    public static long estimateSizeOverhead(long size) {
        return size + 8L + 15L & 0xFFFFFFFFFFFFFFF0L;
    }

    public static long offHeapEntrySize(boolean evictionEnabled, boolean writeMetadataSize, int keySize, int valueSize) {
        return UnpooledOffHeapMemoryAllocator.offHeapEntrySize(evictionEnabled, writeMetadataSize, keySize, valueSize, 0, 0);
    }

    public static long offHeapEntrySize(boolean evictionEnabled, boolean writeMetadataSize, int keySize, int valueSize, int metadataSize, int internalMetadataSize) {
        long size = 0L;
        if (evictionEnabled) {
            size += 16L;
        }
        if (writeMetadataSize) {
            size += 4L;
        }
        size += 8L;
        size += 17L;
        size += (long)keySize;
        size += (long)valueSize;
        size += (long)metadataSize;
        return size += (long)internalMetadataSize;
    }
}

