/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Test;

public class JMSTemporaryDestinationTest
extends JMSClientTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCreateTemporaryQueue() throws Throwable {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            TemporaryQueue queue = session.createTemporaryQueue();
            this.instanceLog.debug((Object)("queue:" + queue.getQueueName()));
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage();
            message.setText("Message temporary");
            producer.send((Message)message);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            message = (TextMessage)consumer.receive(5000L);
            JMSTemporaryDestinationTest.assertNotNull((Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDeleteTemporaryQueue() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            TemporaryQueue queue = session.createTemporaryQueue();
            JMSTemporaryDestinationTest.assertNotNull((Object)queue);
            JMSTemporaryDestinationTest.assertTrue((boolean)(queue instanceof TemporaryQueue));
            Queue queueView = this.getProxyToQueue(queue.getQueueName());
            JMSTemporaryDestinationTest.assertNotNull((Object)queueView);
            TemporaryQueue tempQueue = queue;
            tempQueue.delete();
            JMSTemporaryDestinationTest.assertTrue((String)"Temp Queue should be deleted.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition((jakarta.jms.Queue)queue){
                final /* synthetic */ jakarta.jms.Queue val$queue;
                {
                    this.val$queue = queue;
                }

                public boolean isSatisfied() throws Exception {
                    return JMSTemporaryDestinationTest.this.getProxyToQueue(this.val$queue.getQueueName()) == null;
                }
            }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(50L)));
        }
    }

    @Test(timeout=60000L)
    public void testCreateTemporaryTopic() throws Throwable {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        TemporaryTopic topic = session.createTemporaryTopic();
        this.instanceLog.debug((Object)("topic:" + topic.getTopicName()));
        MessageConsumer consumer = session.createConsumer((Destination)topic);
        MessageProducer producer = session.createProducer((Destination)topic);
        TextMessage message = session.createTextMessage();
        message.setText("Message temporary");
        producer.send((Message)message);
        connection.start();
        message = (TextMessage)consumer.receive(5000L);
        JMSTemporaryDestinationTest.assertNotNull((Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDeleteTemporaryTopic() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            TemporaryTopic topic = session.createTemporaryTopic();
            JMSTemporaryDestinationTest.assertNotNull((Object)topic);
            JMSTemporaryDestinationTest.assertTrue((boolean)(topic instanceof TemporaryTopic));
            Queue queueView = this.getProxyToQueue(topic.getTopicName());
            JMSTemporaryDestinationTest.assertNotNull((Object)queueView);
            TemporaryTopic tempTopic = topic;
            tempTopic.delete();
            JMSTemporaryDestinationTest.assertTrue((String)"Temp Queue should be deleted.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition((Topic)topic){
                final /* synthetic */ Topic val$topic;
                {
                    this.val$topic = topic;
                }

                public boolean isSatisfied() throws Exception {
                    return JMSTemporaryDestinationTest.this.getProxyToQueue(this.val$topic.getTopicName()) == null;
                }
            }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(50L)));
        }
    }
}

