/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.stream.Stream;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConsumerTest
extends ActiveMQTestBase {
    private final boolean durable;
    private final boolean netty;
    private ActiveMQServer server;
    private final SimpleString QUEUE = new SimpleString("ConsumerTestQueue");
    private ServerLocator locator;

    @Parameterized.Parameters(name="isNetty={0}, persistent={1}")
    public static Collection getParameters() {
        return Arrays.asList({true, true}, {false, false}, {false, true}, {true, false});
    }

    public ConsumerTest(boolean netty, boolean durable) {
        this.netty = netty;
        this.durable = durable;
    }

    protected boolean isNetty() {
        return this.netty;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(this.durable, this.isNetty());
        this.server.getConfiguration().setAddressQueueScanPeriod(10L);
        this.server.start();
        this.locator = this.createFactory(this.isNetty());
    }

    @Before
    public void createQueue() throws Exception {
        ServerLocator locator = this.createFactory(this.isNetty());
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSessionFactory sf2 = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true, true);
        this.server.createQueue(new QueueConfiguration(this.QUEUE).setRoutingType(RoutingType.ANYCAST));
        session.close();
        sf.close();
        locator.close();
    }

    @Test
    public void testStressConnection() throws Exception {
        for (int i = 0; i < 10; ++i) {
            ServerLocator locatorSendx = this.createFactory(this.isNetty()).setReconnectAttempts(15);
            ClientSessionFactory factoryx = locatorSendx.createSessionFactory();
            factoryx.close();
            locatorSendx.close();
        }
    }

    @Test
    public void testSimpleSend() throws Throwable {
        this.receive(false);
    }

    @Test
    public void testSimpleSendWithCloseConsumer() throws Throwable {
        this.receive(true);
    }

    private void receive(boolean cancelOnce) throws Throwable {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, false);
        ClientProducer producer = session.createProducer(this.QUEUE);
        ClientMessage message = session.createMessage((byte)3, true, 0L, System.currentTimeMillis(), (byte)4);
        message.getBodyBuffer().writeString("hi");
        message.putStringProperty("hello", "elo");
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        session.commit();
        session.close();
        if (this.durable) {
            this.server.stop();
            this.server.start();
        }
        sf = this.createSessionFactory(this.locator);
        session = sf.createSession(false, true, true, false);
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        if (cancelOnce) {
            ClientConsumerInternal consumerInternal = (ClientConsumerInternal)consumer;
            Wait.waitFor(() -> consumerInternal.getBufferSize() > 0);
            consumer.close();
            consumer = session.createConsumer(this.QUEUE);
        }
        ClientMessage message2 = consumer.receive(1000L);
        Assert.assertNotNull((Object)message2);
        this.instanceLog.debug((Object)("Id::" + message2.getMessageID()));
        this.instanceLog.debug((Object)("Received " + message2));
        this.instanceLog.debug((Object)("Clie:" + ByteUtil.bytesToHex((byte[])message2.getBuffer().array(), (int)4)));
        this.instanceLog.debug((Object)("String::" + message2.getReadOnlyBodyBuffer().readString()));
        Assert.assertEquals((Object)"elo", (Object)message2.getStringProperty("hello"));
        Assert.assertEquals((Object)"hi", (Object)message2.getReadOnlyBodyBuffer().readString());
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.close();
    }

    @Test
    public void testSendReceiveAMQP() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(2, 2);
    }

    @Test
    public void testSendReceiveCore() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(1, 1);
    }

    @Test
    public void testSendAMQPReceiveCore() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoCreateMulticastAddress() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        ConsumerTest.assertNull((Object)this.server.getAddressInfo(SimpleString.toSimpleString((String)"topic")));
        ConnectionFactory factorySend = this.createFactory(2);
        try (Connection connection = factorySend.createConnection();){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic("topic");
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.setDeliveryMode(2);
            TextMessage msg = session.createTextMessage("hello");
            msg.setIntProperty("mycount", 0);
            producer.send((Message)msg);
        }
        ConsumerTest.assertNotNull((Object)this.server.getAddressInfo(SimpleString.toSimpleString((String)"topic")));
        ConsumerTest.assertEquals((Object)RoutingType.MULTICAST, (Object)this.server.getAddressInfo(SimpleString.toSimpleString((String)"topic")).getRoutingType());
        ConsumerTest.assertEquals((long)0L, (long)this.server.getTotalMessageCount());
    }

    @Test
    public void testAutoCreateCOnConsumerAMQP() throws Throwable {
        this.testAutoCreate(2);
    }

    @Test
    public void testAutoCreateCOnConsumerCore() throws Throwable {
        this.testAutoCreate(1);
    }

    @Test
    public void testAutoCreateCOnConsumerOpenWire() throws Throwable {
        this.testAutoCreate(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAutoCreate(int protocol) throws Throwable {
        SimpleString thisQueue = SimpleString.toSimpleString((String)"ThisQueue");
        if (!this.isNetty()) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            ConnectionFactory factorySend = this.createFactory(protocol);
            try (Connection connection = factorySend.createConnection();){
                Session session = connection.createSession(false, 1);
                jakarta.jms.Queue queue = session.createQueue(thisQueue.toString());
                MessageProducer producer = session.createProducer((Destination)queue);
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                connection.start();
                producer.send((Message)session.createTextMessage("hello"));
                Assert.assertNotNull((Object)consumer.receive(5000L));
                consumer.close();
                session.close();
            }
            Wait.waitFor(() -> this.server.getAddressInfo(thisQueue) == null, (long)1000L, (long)10L);
            ConsumerTest.assertNull((Object)this.server.getAddressInfo(thisQueue));
            ConsumerTest.assertEquals((long)0L, (long)this.server.getTotalMessageCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContextOnConsumerAMQP() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        ConsumerTest.assertNull((Object)this.server.getAddressInfo(SimpleString.toSimpleString((String)"queue")));
        ConnectionFactory factory = this.createFactory(2);
        JMSContext context = factory.createContext("admin", "admin", 1);
        try {
            jakarta.jms.Queue queue = context.createQueue("queue");
            JMSConsumer consumer = context.createConsumer((Destination)queue);
            ServerConsumer serverConsumer = null;
            for (ServerSession session : this.server.getSessions()) {
                Iterator iterator = session.getServerConsumers().iterator();
                while (iterator.hasNext()) {
                    ServerConsumer sessionConsumer;
                    serverConsumer = sessionConsumer = (ServerConsumer)iterator.next();
                }
            }
            consumer.close();
            Assert.assertTrue((boolean)(serverConsumer.getProtocolContext() instanceof ProtonServerSenderContext));
            AMQPSessionContext sessionContext = ((ProtonServerSenderContext)serverConsumer.getProtocolContext()).getSessionContext();
            Wait.assertEquals((int)0, () -> sessionContext.getSenderCount(), (long)1000L, (long)10L);
        }
        finally {
            context.stop();
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDeleteAutoCreatedAddressAndQueue() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        ConsumerTest.assertNull((Object)this.server.getAddressInfo(SimpleString.toSimpleString((String)"queue")));
        ConnectionFactory factorySend = this.createFactory(2);
        try (Connection connection = factorySend.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue("queue");
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.setDeliveryMode(2);
            TextMessage msg = session.createTextMessage("hello");
            msg.setIntProperty("mycount", 0);
            producer.send((Message)msg);
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            ConsumerTest.assertNotNull((Object)consumer.receive(1000L));
        }
        Wait.assertTrue(() -> this.server.getAddressInfo(SimpleString.toSimpleString((String)"queue")) == null);
        Wait.assertTrue(() -> this.server.locateQueue(SimpleString.toSimpleString((String)"queue")) == null);
        Wait.assertEquals((long)0L, () -> ((ActiveMQServer)this.server).getTotalMessageCount());
    }

    @Test
    public void testSendCoreReceiveAMQP() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(1, 2);
    }

    @Test
    public void testSendOpenWireReceiveAMQP() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(3, 2);
    }

    @Test
    public void testSendAMQPReceiveOpenWire() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(2, 3);
    }

    @Test
    public void testOpenWireReceiveCore() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(3, 1);
    }

    @Test
    public void testCoreReceiveOpenwire() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(1, 3);
    }

    private ConnectionFactory createFactory(int protocol) {
        switch (protocol) {
            case 1: {
                org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory coreCF = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory();
                coreCF.setCompressLargeMessage(true);
                coreCF.setMinLargeMessageSize(10240);
                return coreCF;
            }
            case 2: {
                return new JmsConnectionFactory("amqp://localhost:61616");
            }
            case 3: {
                return new ActiveMQConnectionFactory("tcp://localhost:61616");
            }
        }
        return null;
    }

    public void internalSimpleSend(int protocolSender, int protocolConsumer) throws Throwable {
        Throwable throwable;
        jakarta.jms.Queue queue2;
        Throwable throwable2;
        Session session;
        ConnectionFactory factorySend = this.createFactory(protocolSender);
        ConnectionFactory factoryConsume = protocolConsumer == protocolSender ? factorySend : this.createFactory(protocolConsumer);
        StringBuilder bufferLarge = new StringBuilder();
        while (bufferLarge.length() < 102400) {
            bufferLarge.append("          ");
        }
        String bufferLargeContent = bufferLarge.toString();
        try (Connection connection = factorySend.createConnection();){
            connection.start();
            session = connection.createSession(false, 1);
            throwable2 = null;
            try {
                queue2 = session.createQueue(this.QUEUE.toString());
                throwable = null;
                try (MessageProducer producer = session.createProducer((Destination)queue2);){
                    producer.setDeliveryMode(2);
                    TextMessage msg = session.createTextMessage("hello");
                    msg.setIntProperty("mycount", 0);
                    producer.send((Message)msg);
                    msg = session.createTextMessage(bufferLargeContent);
                    msg.setIntProperty("mycount", 1);
                    producer.send((Message)msg);
                }
                catch (Throwable msg) {
                    throwable = msg;
                    throw msg;
                }
            }
            catch (Throwable queue2) {
                throwable2 = queue2;
                throw queue2;
            }
            finally {
                if (session != null) {
                    if (throwable2 != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable queue2) {
                            throwable2.addSuppressed(queue2);
                        }
                    } else {
                        session.close();
                    }
                }
            }
        }
        connection = factoryConsume.createConnection();
        var8_8 = null;
        try {
            connection.start();
            session = connection.createSession(false, 1);
            throwable2 = null;
            try {
                queue2 = session.createQueue(this.QUEUE.toString());
                throwable = null;
                try (MessageConsumer consumer = session.createConsumer((Destination)queue2);){
                    TextMessage message = (TextMessage)consumer.receive(1000L);
                    Assert.assertNotNull((Object)message);
                    Assert.assertEquals((long)0L, (long)message.getIntProperty("mycount"));
                    Assert.assertEquals((Object)"hello", (Object)message.getText());
                    message = (TextMessage)consumer.receive(1000L);
                    Assert.assertNotNull((Object)message);
                    Assert.assertEquals((long)1L, (long)message.getIntProperty("mycount"));
                    Assert.assertEquals((Object)bufferLargeContent, (Object)message.getText());
                    Wait.waitFor(() -> this.server.getPagingManager().getGlobalSize() == 0L, (long)5000L, (long)100L);
                    Assert.assertEquals((long)0L, (long)this.server.getPagingManager().getGlobalSize());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
            finally {
                if (session != null) {
                    if (throwable2 != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                    } else {
                        session.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var8_8 = throwable6;
            throw throwable6;
        }
        finally {
            if (connection != null) {
                if (var8_8 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable7) {
                        var8_8.addSuppressed(throwable7);
                    }
                } else {
                    connection.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalSend(int protocolSender, int protocolConsumer) throws Throwable {
        this.internalSimpleSend(protocolSender, protocolConsumer);
        ConnectionFactory factorySend = this.createFactory(protocolSender);
        ConnectionFactory factoryConsume = protocolConsumer == protocolSender ? factorySend : this.createFactory(protocolConsumer);
        try (Connection connection = factorySend.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(this.QUEUE.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            if (this.durable) {
                producer.setDeliveryMode(2);
            } else {
                producer.setDeliveryMode(1);
            }
            long time = System.currentTimeMillis();
            int NUMBER_OF_MESSAGES = this.durable ? 5 : 50;
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                TextMessage msg = session.createTextMessage("hello " + i);
                msg.setIntProperty("mycount", i);
                producer.send((Message)msg);
                ObjectMessage objectMessage = session.createObjectMessage((Serializable)new MyTest().setI(i));
                producer.send((Message)objectMessage);
                MapMessage mapMessage = session.createMapMessage();
                mapMessage.setInt("intOne", i);
                mapMessage.setString("stringOne", Integer.toString(i));
                producer.send((Message)mapMessage);
                StreamMessage stream = session.createStreamMessage();
                stream.writeBoolean(true);
                stream.writeInt(i);
                producer.send((Message)stream);
                BytesMessage bytes = session.createBytesMessage();
                bytes.writeUTF("string " + i);
                producer.send((Message)bytes);
            }
            long end = System.currentTimeMillis();
            this.instanceLog.debug((Object)("Time = " + (end - time)));
            TextMessage dummyMessage = session.createTextMessage();
            dummyMessage.setJMSType("car");
            dummyMessage.setStringProperty("color", "red");
            dummyMessage.setLongProperty("weight", 3000L);
            dummyMessage.setText("testSelectorExampleFromSpecs:1");
            producer.send((Message)dummyMessage);
            dummyMessage = session.createTextMessage();
            dummyMessage.setJMSType("car");
            dummyMessage.setStringProperty("color", "blue");
            dummyMessage.setLongProperty("weight", 3000L);
            dummyMessage.setText("testSelectorExampleFromSpecs:2");
            producer.send((Message)dummyMessage);
            connection.close();
            if (this.durable) {
                this.server.stop();
                this.server.start();
            }
            connection = factoryConsume.createConnection();
            session = connection.createSession(false, 1);
            queue = session.createQueue(this.QUEUE.toString());
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                TextMessage message = (TextMessage)consumer.receive(1000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((long)i, (long)message.getIntProperty("mycount"));
                Assert.assertEquals((Object)("hello " + i), (Object)message.getText());
                ObjectMessage objectMessage = (ObjectMessage)consumer.receive(5000L);
                Assert.assertNotNull((Object)objectMessage);
                Assert.assertEquals((long)i, (long)((MyTest)objectMessage.getObject()).getI());
                MapMessage mapMessage = (MapMessage)consumer.receive(1000L);
                Assert.assertNotNull((Object)mapMessage);
                Assert.assertEquals((long)i, (long)mapMessage.getInt("intOne"));
                Assert.assertEquals((Object)Integer.toString(i), (Object)mapMessage.getString("stringOne"));
                StreamMessage stream = (StreamMessage)consumer.receive(5000L);
                Assert.assertTrue((boolean)stream.readBoolean());
                Assert.assertEquals((long)i, (long)stream.readInt());
                BytesMessage bytes = (BytesMessage)consumer.receive(5000L);
                Assert.assertEquals((Object)("string " + i), (Object)bytes.readUTF());
            }
            consumer.close();
            consumer = session.createConsumer((Destination)queue, "JMSType = 'car' AND color = 'blue' AND weight > 2500");
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            Assert.assertEquals((Object)"testSelectorExampleFromSpecs:2", (Object)msg.getText());
            consumer.close();
            consumer = session.createConsumer((Destination)queue);
            msg = (TextMessage)consumer.receive(5000L);
            Assert.assertNotNull((Object)msg);
            Assert.assertNull((Object)consumer.receiveNoWait());
            Wait.waitFor(() -> this.server.getPagingManager().getGlobalSize() == 0L, (long)5000L, (long)100L);
            Assert.assertEquals((long)0L, (long)this.server.getPagingManager().getGlobalSize());
        }
    }

    @Test
    public void testConsumerAckImmediateAutoCommitTrue() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, true);
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive(1000L);
            Assert.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        Assert.assertEquals((long)0L, (long)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        Assert.assertEquals((long)0L, (long)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
        session.close();
    }

    @Test
    public void testConsumerAckImmediateAutoCommitFalse() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, false, true);
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive(1000L);
            Assert.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        Assert.assertEquals((long)0L, (long)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        Assert.assertEquals((long)0L, (long)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
        session.close();
    }

    @Test
    public void testConsumerAckImmediateAckIgnored() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, true);
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive(1000L);
            Assert.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
            if (i >= 50) continue;
            message2.acknowledge();
        }
        Assert.assertEquals((long)0L, (long)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        Assert.assertEquals((long)0L, (long)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
        session.close();
    }

    @Test
    public void testConsumerAckImmediateCloseSession() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, true);
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive(1000L);
            Assert.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
            if (i >= 50) continue;
            message2.acknowledge();
        }
        Assert.assertEquals((long)0L, (long)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        Assert.assertEquals((long)0L, (long)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
        session.close();
        Assert.assertEquals((long)0L, (long)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        Assert.assertEquals((long)0L, (long)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
    }

    @Test
    public void testAcksWithSmallSendWindow() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.close();
        sf.close();
        final CountDownLatch latch = new CountDownLatch(100);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new Interceptor(){

            public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
                if (packet.getType() == 41) {
                    latch.countDown();
                }
                return true;
            }
        });
        ServerLocator locator = this.createInVMNonHALocator().setConfirmationWindowSize(100).setAckBatchSize(-1);
        ClientSessionFactory sfReceive = this.createSessionFactory(locator);
        ClientSession sessionRec = sfReceive.createSession(false, true, true);
        ClientConsumer consumer = sessionRec.createConsumer(this.QUEUE);
        consumer.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage message) {
                try {
                    message.acknowledge();
                }
                catch (ActiveMQException e) {
                    e.printStackTrace();
                }
            }
        });
        sessionRec.start();
        Assert.assertTrue((boolean)latch.await(60L, TimeUnit.SECONDS));
        sessionRec.close();
        locator.close();
    }

    @Test
    public void testConsumeWithNoConsumerFlowControl() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setConsumerWindowSize(-1);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        session.start();
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = consumer.receive(10000L);
            ConsumerTest.assertNotNull((Object)message);
            message.acknowledge();
        }
        session.close();
        sf.close();
        locator.close();
    }

    @Test
    public void testClearListener() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.start();
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        consumer.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage msg) {
            }
        });
        consumer.setMessageHandler(null);
        consumer.receiveImmediate();
        session.close();
    }

    @Test
    public void testNoReceiveWithListener() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        consumer.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage msg) {
            }
        });
        try {
            consumer.receiveImmediate();
            Assert.fail((String)"Should throw exception");
        }
        catch (ActiveMQIllegalStateException activeMQIllegalStateException) {
        }
        catch (ActiveMQException me) {
            Assert.fail((String)"Wrong exception code");
        }
        session.close();
    }

    @Test
    public void testReceiveAndResend() throws Exception {
        ConcurrentHashSet sessions = new ConcurrentHashSet();
        final AtomicInteger errors = new AtomicInteger(0);
        final SimpleString QUEUE_RESPONSE = SimpleString.toSimpleString((String)"QUEUE_RESPONSE");
        int numberOfSessions = 50;
        int numberOfMessages = 10;
        CountDownLatch latchReceive = new CountDownLatch(500);
        ClientSessionFactory sf = this.locator.createSessionFactory();
        for (int i = 0; i < 50; ++i) {
            ClientSession session = sf.createSession(false, true, true);
            sessions.add(session);
            session.createQueue(new QueueConfiguration(this.QUEUE.concat("" + i)).setAddress(this.QUEUE).setDurable(Boolean.valueOf(true)));
            if (i == 0) {
                session.createQueue(new QueueConfiguration(QUEUE_RESPONSE));
            }
            ClientConsumer consumer = session.createConsumer(this.QUEUE.concat("" + i));
            sessions.add(consumer);
            consumer.setMessageHandler(new MessageHandler((Set)sessions, QUEUE_RESPONSE, errors, latchReceive){
                final /* synthetic */ Set val$sessions;
                final /* synthetic */ SimpleString val$QUEUE_RESPONSE;
                final /* synthetic */ AtomicInteger val$errors;
                final /* synthetic */ CountDownLatch val$latchReceive;
                {
                    this.val$sessions = set;
                    this.val$QUEUE_RESPONSE = simpleString;
                    this.val$errors = atomicInteger;
                    this.val$latchReceive = countDownLatch;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onMessage(ClientMessage msg) {
                    try {
                        ServerLocator locatorSendx = ConsumerTest.this.createFactory(ConsumerTest.this.isNetty()).setReconnectAttempts(15);
                        ClientSessionFactory factoryx = locatorSendx.createSessionFactory();
                        ClientSession sessionSend = factoryx.createSession(true, true);
                        this.val$sessions.add(sessionSend);
                        this.val$sessions.add(locatorSendx);
                        this.val$sessions.add(factoryx);
                        ClientProducer prod = sessionSend.createProducer(this.val$QUEUE_RESPONSE);
                        sessionSend.start();
                        this.val$sessions.add(prod);
                        msg.acknowledge();
                        prod.send((org.apache.activemq.artemis.api.core.Message)sessionSend.createMessage(true));
                        prod.close();
                        sessionSend.commit();
                        sessionSend.close();
                        factoryx.close();
                        if (Thread.currentThread().isInterrupted()) {
                            System.err.println("Netty has interrupted a thread!!!");
                            this.val$errors.incrementAndGet();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        this.val$errors.incrementAndGet();
                    }
                    finally {
                        this.val$latchReceive.countDown();
                    }
                }
            });
            session.start();
        }
        Thread tCons = new Thread(){

            @Override
            public void run() {
                try {
                    ClientMessage msg;
                    ServerLocator locatorSend = ConsumerTest.this.createFactory(ConsumerTest.this.isNetty());
                    ClientSessionFactory factory = locatorSend.createSessionFactory();
                    ClientSession sessionSend = factory.createSession(true, true);
                    ClientConsumer cons = sessionSend.createConsumer(QUEUE_RESPONSE);
                    sessionSend.start();
                    for (int i = 0; i < 500 && (msg = cons.receive(5000L)) != null; ++i) {
                        msg.acknowledge();
                    }
                    if (cons.receiveImmediate() != null) {
                        ConsumerTest.this.instanceLog.debug((Object)"ERROR: Received an extra message");
                        errors.incrementAndGet();
                    }
                    sessionSend.close();
                    factory.close();
                    locatorSend.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
        };
        tCons.start();
        ClientSession mainSessionSend = sf.createSession(true, true);
        ClientProducer mainProd = mainSessionSend.createProducer(this.QUEUE);
        for (int i = 0; i < 10; ++i) {
            mainProd.send((org.apache.activemq.artemis.api.core.Message)mainSessionSend.createMessage(true));
        }
        latchReceive.await(2L, TimeUnit.MINUTES);
        tCons.join();
        sf.close();
        ConsumerTest.assertEquals((String)"Had errors along the execution", (long)0L, (long)errors.get());
    }

    @Test
    public void testConsumerCreditsOnRollback() throws Exception {
        this.locator.setConsumerWindowSize(10000);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createTransactedSession();
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        byte[] bytes = new byte[1000];
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(false);
            message.getBodyBuffer().writeBytes(bytes);
            message.putIntProperty("count", i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.commit();
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (int i = 0; i < 110; ++i) {
            boolean redelivered;
            ClientMessage message = consumer.receive();
            int count = message.getIntProperty("count");
            boolean bl = redelivered = message.getDeliveryCount() > 1;
            if (count % 2 == 0 && !redelivered) {
                session.rollback();
                continue;
            }
            session.commit();
        }
        session.close();
    }

    @Test
    public void testInVMURI() throws Exception {
        this.locator.close();
        ServerLocator locator = this.addServerLocator(ServerLocatorImpl.newLocator((String)"vm:/1"));
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession();
        ClientProducer producer = session.createProducer(this.QUEUE);
        producer.send((org.apache.activemq.artemis.api.core.Message)session.createMessage(true));
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        Assert.assertNotNull((Object)consumer.receiveImmediate());
        session.close();
        factory.close();
    }

    @Test
    public void testConsumerCreditsOnRollbackLargeMessages() throws Exception {
        this.locator.setConsumerWindowSize(10000).setMinLargeMessageSize(1000);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createTransactedSession();
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        byte[] bytes = new byte[10000];
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(false);
            message.getBodyBuffer().writeBytes(bytes);
            message.putIntProperty("count", i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.commit();
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (int i = 0; i < 110; ++i) {
            boolean redelivered;
            ClientMessage message = consumer.receive();
            int count = message.getIntProperty("count");
            boolean bl = redelivered = message.getDeliveryCount() > 1;
            if (count % 2 == 0 && !redelivered) {
                session.rollback();
                continue;
            }
            session.commit();
        }
        session.close();
    }

    @Test
    public void testMultipleConsumersOnSharedQueue() throws Throwable {
        if (!this.isNetty() || this.durable) {
            return;
        }
        boolean durable = false;
        long TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(1L);
        int forks = 100;
        int queues = 100;
        boolean runs = true;
        boolean messages = true;
        ConnectionFactory factorySend = this.createFactory(1);
        AtomicLongArray receivedMessages = new AtomicLongArray(100);
        Thread[] producersRunners = new Thread[100];
        Thread[] consumersRunners = new Thread[100];
        CyclicBarrier onStartRun = new CyclicBarrier(201);
        CyclicBarrier onFinishRun = new CyclicBarrier(201);
        int messagesSent = 100;
        AtomicInteger messagesRecieved = new AtomicInteger(0);
        int i = 0;
        while (i < 100) {
            int forkIndex = i++;
            String queueName = "q_" + forkIndex % 100;
            Thread producerRunner = new Thread(() -> {
                try (Connection connection = factorySend.createConnection();){
                    connection.start();
                    try (Session session = connection.createSession(false, 1);){
                        jakarta.jms.Queue queue = session.createQueue(queueName);
                        try (MessageProducer producer = session.createProducer((Destination)queue);){
                            producer.setDeliveryMode(1);
                            for (int r = 0; r < 1; ++r) {
                                onStartRun.await();
                                for (int m = 0; m < 1; ++m) {
                                    BytesMessage bytesMessage = session.createBytesMessage();
                                    bytesMessage.writeInt(forkIndex);
                                    producer.send((Message)bytesMessage);
                                }
                                onFinishRun.await();
                            }
                        }
                        catch (InterruptedException | BrokenBarrierException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            });
            producerRunner.setDaemon(true);
            Thread consumerRunner = new Thread(() -> {
                try (Connection connection = factorySend.createConnection();){
                    connection.start();
                    try (Session session = connection.createSession(false, 1);){
                        jakarta.jms.Queue queue = session.createQueue(queueName);
                        try (MessageConsumer consumer = session.createConsumer((Destination)queue);){
                            for (int r = 0; r < 1; ++r) {
                                onStartRun.await();
                                while (messagesRecieved.get() != 100) {
                                    BytesMessage receivedMessage = (BytesMessage)consumer.receive(1000L);
                                    if (receivedMessage == null) continue;
                                    int receivedConsumerIndex = receivedMessage.readInt();
                                    receivedMessages.getAndIncrement(receivedConsumerIndex);
                                    messagesRecieved.incrementAndGet();
                                }
                                onFinishRun.await();
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (BrokenBarrierException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            });
            consumerRunner.setDaemon(true);
            consumersRunners[forkIndex] = consumerRunner;
            producersRunners[forkIndex] = producerRunner;
        }
        Stream.of(consumersRunners).forEach(Thread::start);
        Stream.of(producersRunners).forEach(Thread::start);
        long messagesPerRun = 100L;
        for (int r = 0; r < 1; ++r) {
            onStartRun.await(TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
            this.instanceLog.debug((Object)("started run " + r));
            long start = System.currentTimeMillis();
            onFinishRun.await(TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
            long elapsedMillis = System.currentTimeMillis() - start;
            this.instanceLog.debug((Object)(100000L / elapsedMillis + " msg/sec"));
        }
        Stream.of(producersRunners).forEach(runner -> {
            try {
                runner.join(TIMEOUT_MILLIS * 1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        Stream.of(producersRunners).forEach(Thread::interrupt);
        Stream.of(consumersRunners).forEach(runner -> {
            try {
                runner.join(TIMEOUT_MILLIS * 1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        Stream.of(consumersRunners).forEach(Thread::interrupt);
        for (int i2 = 0; i2 < 100; ++i2) {
            Assert.assertEquals((String)("The consumer " + i2 + " must receive all the messages sent."), (long)1L, (long)receivedMessages.get(i2));
        }
    }

    @Test
    public void testConsumerXpathSelector() throws Exception {
        SimpleString BODY = SimpleString.toSimpleString((String)"<root><a key='first' num='1'/><b key='second' num='2'>b</b></root>");
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, false, true);
        ClientProducer producer = session.createProducer(this.QUEUE);
        ClientMessage message = session.createMessage(false);
        message.setType((byte)3);
        message.getBodyBuffer().writeNullableSimpleString(SimpleString.toSimpleString((String)"wrong"));
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        message = session.createMessage(false);
        message.setType((byte)3);
        message.getBodyBuffer().writeNullableSimpleString(BODY);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        ClientConsumer consumer = session.createConsumer(this.QUEUE.toString(), "XPATH 'root/a'");
        session.start();
        ClientMessage message2 = consumer.receive(5000L);
        Assert.assertNotNull((Object)message2);
        Assert.assertEquals((Object)BODY, (Object)message2.getBodyBuffer().readNullableSimpleString());
        Assert.assertEquals((long)1L, (long)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
        session.close();
    }

    public static class MyTest
    implements Serializable {
        int i;

        public int getI() {
            return this.i;
        }

        public MyTest setI(int i) {
            this.i = i;
            return this;
        }
    }
}

