/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class DeadLetterAddressTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession clientSession;
    private ServerLocator locator;

    @Test
    public void testBasicSend() throws Exception {
        SimpleString dla = new SimpleString("DLA");
        SimpleString qName = new SimpleString("q1");
        SimpleString adName = new SimpleString("ad1");
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla);
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)addressSettings);
        SimpleString dlq = new SimpleString("DLQ1");
        this.clientSession.createQueue(new QueueConfiguration(dlq).setAddress(dla).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setAddress(adName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(adName);
        producer.send((Message)this.createTextMessage(this.clientSession, "heyho!"));
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receive(500L);
        m.acknowledge();
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        this.clientSession.rollback();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(dlq);
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        DeadLetterAddressTest.assertEquals((Object)"q1", (Object)m.getStringProperty(Message.HDR_ORIGINAL_QUEUE));
        DeadLetterAddressTest.assertEquals((Object)"ad1", (Object)m.getStringProperty(Message.HDR_ORIGINAL_ADDRESS));
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
    }

    @Test
    public void testLargeMessageFileLeak() throws Exception {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        Assume.assumeTrue((boolean)(os instanceof UnixOperatingSystemMXBean));
        long fdBaseline = ((UnixOperatingSystemMXBean)os).getOpenFileDescriptorCount();
        int SIZE = 2048;
        SimpleString dla = new SimpleString("DLA");
        SimpleString qName = new SimpleString("q1");
        SimpleString adName = new SimpleString("ad1");
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla);
        this.server.getAddressSettingsRepository().addMatch(adName.toString(), (Object)addressSettings);
        SimpleString dlq = new SimpleString("DLQ1");
        this.clientSession.createQueue(new QueueConfiguration(dlq).setAddress(dla).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setAddress(adName).setDurable(Boolean.valueOf(false)));
        for (int i = 0; i < 10; ++i) {
            ClientProducer producer = this.clientSession.createProducer(adName);
            ClientMessage clientFile = this.clientSession.createMessage(true);
            clientFile.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream((long)2048L));
            producer.send((Message)clientFile);
            this.clientSession.start();
            ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
            ClientMessage m = clientConsumer.receive(500L);
            m.acknowledge();
            Assert.assertNotNull((Object)m);
            this.clientSession.rollback();
            m = clientConsumer.receiveImmediate();
            Assert.assertNull((Object)m);
            clientConsumer.close();
        }
        Wait.assertTrue((String)"File descriptors are leaking", () -> ((UnixOperatingSystemMXBean)os).getOpenFileDescriptorCount() - fdBaseline <= 0L);
    }

    @Test
    public void testBasicSendWithDLAButNoBinding() throws Exception {
        SimpleString dla = new SimpleString("DLA");
        SimpleString qName = new SimpleString("q1");
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        this.clientSession.createQueue(new QueueConfiguration(qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        producer.send((Message)this.createTextMessage(this.clientSession, "heyho!"));
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receive(500L);
        m.acknowledge();
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        this.clientSession.rollback();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        Queue q = (Queue)this.server.getPostOffice().getBinding(qName).getBindable();
        Assert.assertEquals((long)0L, (long)q.getDeliveringCount());
    }

    @Test
    public void testBasicSend2times() throws Exception {
        SimpleString dla = new SimpleString("DLA");
        SimpleString qName = new SimpleString("q1");
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(2).setDeadLetterAddress(dla);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        SimpleString dlq = new SimpleString("DLQ1");
        this.clientSession.createQueue(new QueueConfiguration(dlq).setAddress(dla).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        producer.send((Message)this.createTextMessage(this.clientSession, "heyho!"));
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receive(5000L);
        m.acknowledge();
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        this.clientSession.rollback();
        this.clientSession.start();
        m = clientConsumer.receive(5000L);
        m.acknowledge();
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        this.clientSession.rollback();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(dlq);
        m = clientConsumer.receive(5000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
    }

    @Test
    public void testReceiveWithListeners() throws Exception {
        SimpleString dla = new SimpleString("DLA");
        SimpleString qName = new SimpleString("q1");
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(2).setDeadLetterAddress(dla);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        SimpleString dlq = new SimpleString("DLQ1");
        this.clientSession.createQueue(new QueueConfiguration(dlq).setAddress(dla).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        producer.send((Message)this.createTextMessage(this.clientSession, "heyho!"));
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        CountDownLatch latch = new CountDownLatch(2);
        TestHandler handler = new TestHandler(latch, this.clientSession);
        clientConsumer.setMessageHandler((MessageHandler)handler);
        this.clientSession.start();
        DeadLetterAddressTest.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        DeadLetterAddressTest.assertEquals((long)handler.count, (long)2L);
        clientConsumer = this.clientSession.createConsumer(dlq);
        ClientMessage m = clientConsumer.receive(5000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
    }

    @Test
    public void testBasicSendToMultipleQueues() throws Exception {
        SimpleString dla = new SimpleString("DLA");
        SimpleString qName = new SimpleString("q1");
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        SimpleString dlq = new SimpleString("DLQ1");
        SimpleString dlq2 = new SimpleString("DLQ2");
        this.clientSession.createQueue(new QueueConfiguration(dlq).setAddress(dla).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(dlq2).setAddress(dla).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        producer.send((Message)this.createTextMessage(this.clientSession, "heyho!"));
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receive(500L);
        m.acknowledge();
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        this.clientSession.rollback();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(dlq);
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        m.acknowledge();
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(dlq2);
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        m.acknowledge();
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        clientConsumer.close();
    }

    @Test
    public void testBasicSendToNoQueue() throws Exception {
        SimpleString qName = new SimpleString("q1");
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(1);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        this.clientSession.createQueue(new QueueConfiguration(qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        producer.send((Message)this.createTextMessage(this.clientSession, "heyho!"));
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receive(500L);
        m.acknowledge();
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        this.clientSession.rollback();
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
    }

    @Test
    public void testHeadersSet() throws Exception {
        int MAX_DELIVERIES = 16;
        int NUM_MESSAGES = 5;
        SimpleString dla = new SimpleString("DLA");
        SimpleString qName = new SimpleString("q1");
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(16).setDeadLetterAddress(dla);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        SimpleString dlq = new SimpleString("DLQ1");
        this.clientSession.createQueue(new QueueConfiguration(dlq).setAddress(dla).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setDurable(Boolean.valueOf(false)));
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator);
        ClientSession sendSession = sessionFactory.createSession(false, true, true);
        ClientProducer producer = sendSession.createProducer(qName);
        HashMap<String, Long> origIds = new HashMap<String, Long>();
        for (int i = 0; i < 5; ++i) {
            ClientMessage tm = this.createTextMessage(this.clientSession, "Message:" + i);
            producer.send((Message)tm);
        }
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        this.clientSession.start();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 5; ++j) {
                ClientMessage tm = clientConsumer.receive(1000L);
                Assert.assertNotNull((Object)tm);
                tm.acknowledge();
                if (i == 0) {
                    origIds.put("Message:" + j, tm.getMessageID());
                }
                Assert.assertEquals((Object)("Message:" + j), (Object)tm.getBodyBuffer().readString());
            }
            this.clientSession.rollback();
        }
        long timeout = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < timeout && this.getMessageCount((Queue)this.server.getPostOffice().getBinding(qName).getBindable()) != 0) {
            Thread.sleep(1L);
        }
        Assert.assertEquals((long)0L, (long)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(qName).getBindable()));
        ClientMessage m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        ClientConsumer cc3 = this.clientSession.createConsumer(dlq);
        for (int i = 0; i < 5; ++i) {
            ClientMessage tm = cc3.receive(1000L);
            Assert.assertNotNull((Object)tm);
            String text = tm.getBodyBuffer().readString();
            Assert.assertEquals((Object)("Message:" + i), (Object)text);
            SimpleString origDest = (SimpleString)tm.getObjectProperty(Message.HDR_ORIGINAL_ADDRESS);
            Long origMessageId = (Long)tm.getObjectProperty(Message.HDR_ORIG_MESSAGE_ID);
            Assert.assertEquals((Object)qName, (Object)origDest);
            Long origId = (Long)origIds.get(text);
            Assert.assertEquals((Object)origId, (Object)origMessageId);
        }
        sendSession.close();
    }

    @Test
    public void testDeadlLetterAddressWithDefaultAddressSettings() throws Exception {
        int deliveryAttempt = 3;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString deadLetterAddress = RandomUtil.randomSimpleString();
        SimpleString deadLetterQueue = RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(deliveryAttempt).setDeadLetterAddress(deadLetterAddress);
        this.server.getAddressSettingsRepository().setDefault((Object)addressSettings);
        this.clientSession.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(deadLetterQueue).setAddress(deadLetterAddress).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(address);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queue);
        for (int i = 0; i < deliveryAttempt; ++i) {
            ClientMessage m = clientConsumer.receive(500L);
            Assert.assertNotNull((Object)m);
            Assert.assertEquals((long)(i + 1), (long)m.getDeliveryCount());
            m.acknowledge();
            this.clientSession.rollback();
        }
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNull((String)"not expecting a message", (Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(deadLetterQueue);
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
    }

    @Test
    public void testDeadlLetterAddressWithWildcardAddressSettings() throws Exception {
        int deliveryAttempt = 3;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString deadLetterAddress = RandomUtil.randomSimpleString();
        SimpleString deadLetterQueue = RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setMaxDeliveryAttempts(deliveryAttempt).setDeadLetterAddress(deadLetterAddress);
        this.server.getAddressSettingsRepository().addMatch("*", (Object)addressSettings);
        this.clientSession.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(deadLetterQueue).setAddress(deadLetterAddress).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(address);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queue);
        for (int i = 0; i < deliveryAttempt; ++i) {
            ClientMessage m = clientConsumer.receive(500L);
            Assert.assertNotNull((Object)m);
            Assert.assertEquals((long)(i + 1), (long)m.getDeliveryCount());
            m.acknowledge();
            this.clientSession.rollback();
        }
        ClientMessage m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(deadLetterQueue);
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
    }

    @Test
    public void testDeadLetterAddressWithOverridenSublevelAddressSettings() throws Exception {
        int defaultDeliveryAttempt = 3;
        int specificeDeliveryAttempt = defaultDeliveryAttempt + 1;
        SimpleString address = new SimpleString("prefix.address");
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString defaultDeadLetterAddress = RandomUtil.randomSimpleString();
        SimpleString defaultDeadLetterQueue = RandomUtil.randomSimpleString();
        SimpleString specificDeadLetterAddress = RandomUtil.randomSimpleString();
        SimpleString specificDeadLetterQueue = RandomUtil.randomSimpleString();
        AddressSettings defaultAddressSettings = new AddressSettings().setMaxDeliveryAttempts(defaultDeliveryAttempt).setDeadLetterAddress(defaultDeadLetterAddress);
        this.server.getAddressSettingsRepository().addMatch("*", (Object)defaultAddressSettings);
        AddressSettings specificAddressSettings = new AddressSettings().setMaxDeliveryAttempts(specificeDeliveryAttempt).setDeadLetterAddress(specificDeadLetterAddress);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)specificAddressSettings);
        this.clientSession.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(defaultDeadLetterQueue).setAddress(defaultDeadLetterAddress).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(specificDeadLetterQueue).setAddress(specificDeadLetterAddress).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(address);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queue);
        ClientConsumer defaultDeadLetterConsumer = this.clientSession.createConsumer(defaultDeadLetterQueue);
        ClientConsumer specificDeadLetterConsumer = this.clientSession.createConsumer(specificDeadLetterQueue);
        for (int i = 0; i < defaultDeliveryAttempt; ++i) {
            ClientMessage m = clientConsumer.receive(500L);
            Assert.assertNotNull((Object)m);
            Assert.assertEquals((long)(i + 1), (long)m.getDeliveryCount());
            m.acknowledge();
            this.clientSession.rollback();
        }
        Assert.assertNull((Object)defaultDeadLetterConsumer.receiveImmediate());
        Assert.assertNull((Object)specificDeadLetterConsumer.receiveImmediate());
        ClientMessage m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)specificeDeliveryAttempt, (long)m.getDeliveryCount());
        m.acknowledge();
        this.clientSession.rollback();
        Assert.assertNull((Object)defaultDeadLetterConsumer.receiveImmediate());
        Assert.assertNotNull((Object)specificDeadLetterConsumer.receive(500L));
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)true));
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.locator.setMinLargeMessageSize(1024);
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = this.addClientSession(sessionFactory.createSession(false, true, false));
    }

    class TestHandler
    implements MessageHandler {
        private final CountDownLatch latch;
        int count = 0;
        private final ClientSession clientSession;

        TestHandler(CountDownLatch latch, ClientSession clientSession) {
            this.latch = latch;
            this.clientSession = clientSession;
        }

        public void onMessage(ClientMessage message) {
            ++this.count;
            this.latch.countDown();
            try {
                this.clientSession.rollback(true);
            }
            catch (ActiveMQException e) {
                e.printStackTrace();
            }
            throw new RuntimeException();
        }
    }
}

