/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InVMNonPersistentMessageBufferTest
extends ActiveMQTestBase {
    public static final String address = "testaddress";
    public static final String queueName = "testqueue";
    private ActiveMQServer server;
    private ClientSession session;
    private ClientProducer producer;
    private ClientConsumer consumer;

    @Test
    public void testSimpleSendReceive() throws Exception {
        ClientMessage message = this.session.createMessage(false);
        String body = RandomUtil.randomString();
        message.getBodyBuffer().writeString(body);
        ClientMessage received = this.sendAndReceive(message);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((Object)body, (Object)received.getBodyBuffer().readString());
    }

    @Test
    public void testSimpleSendReceiveWithEmptyBody() throws Exception {
        ClientMessage message = this.session.createMessage(false);
        ClientMessage received = this.sendAndReceive(message);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((long)0L, (long)received.getBodySize());
    }

    @Test
    public void testSendSameMessageMultipleTimes() throws Exception {
        ClientMessage message = this.session.createMessage(false);
        String body = RandomUtil.randomString();
        message.getBodyBuffer().writeString(body);
        int bodySize = message.getBodySize();
        for (int i = 0; i < 10; ++i) {
            ClientMessage received = this.sendAndReceive(message);
            Assert.assertNotNull((Object)received);
            Assert.assertEquals((long)bodySize, (long)received.getBodySize());
            Assert.assertEquals((Object)body, (Object)received.getBodyBuffer().readString());
            Assert.assertFalse((boolean)received.getBodyBuffer().readable());
        }
    }

    @Test
    public void testSendMessageResetSendAgainDifferentBody() throws Exception {
        ClientMessage message = this.session.createMessage(false);
        String body = RandomUtil.randomString();
        for (int i = 0; i < 10; ++i) {
            body = body + "XX";
            message.getBodyBuffer().writeString(body);
            int bodySize = message.getBodySize();
            ClientMessage received = this.sendAndReceive(message);
            Assert.assertNotNull((Object)received);
            Assert.assertEquals((long)bodySize, (long)received.getBodySize());
            Assert.assertEquals((Object)body, (Object)received.getBodyBuffer().readString());
            Assert.assertFalse((boolean)received.getBodyBuffer().readable());
            message.getBodyBuffer().clear();
            Assert.assertEquals((long)4L, (long)message.getBodyBuffer().writerIndex());
            Assert.assertEquals((long)4L, (long)message.getBodyBuffer().readerIndex());
        }
    }

    @Test
    public void testCannotReadPastEndOfMessageBody() throws Exception {
        ClientMessage message = this.session.createMessage(false);
        String body = RandomUtil.randomString();
        message.getBodyBuffer().writeString(body);
        ClientMessage received = this.sendAndReceive(message);
        Assert.assertNotNull((Object)received);
        ActiveMQBuffer buffer = received.getReadOnlyBodyBuffer();
        Assert.assertEquals((Object)body, (Object)buffer.readString());
        try {
            buffer.readByte();
            Assert.fail((String)"Should throw exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((Object)body, (Object)received.getBodyBuffer().readString());
        try {
            received.getBodyBuffer().readByte();
            Assert.fail((String)"Should throw exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        buffer = received.getReadOnlyBodyBuffer();
        Assert.assertEquals((Object)body, (Object)buffer.readString());
        try {
            buffer.readByte();
            Assert.fail((String)"Should throw exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testCanReReadBodyAfterReaderReset() throws Exception {
        ClientMessage message = this.session.createMessage(false);
        String body = RandomUtil.randomString();
        message.getBodyBuffer().writeString(body);
        Assert.assertEquals((long)4L, (long)message.getBodyBuffer().readerIndex());
        String body2 = message.getBodyBuffer().readString();
        Assert.assertEquals((Object)body, (Object)body2);
        message.getBodyBuffer().resetReaderIndex();
        Assert.assertEquals((long)4L, (long)message.getBodyBuffer().readerIndex());
        String body3 = message.getBodyBuffer().readString();
        Assert.assertEquals((Object)body, (Object)body3);
        ClientMessage received = this.sendAndReceive(message);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((Object)body, (Object)received.getBodyBuffer().readString());
        received.getBodyBuffer().resetReaderIndex();
        Assert.assertEquals((long)4L, (long)received.getBodyBuffer().readerIndex());
        String body4 = received.getBodyBuffer().readString();
        Assert.assertEquals((Object)body, (Object)body4);
    }

    protected ServerLocator createFactory() throws Exception {
        if (this.isNetty()) {
            return this.createNettyNonHALocator();
        }
        return this.createInVMNonHALocator();
    }

    protected boolean isNetty() {
        return false;
    }

    protected boolean isPersistent() {
        return false;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(this.isPersistent(), this.isNetty());
        this.server.start();
        ServerLocator locator = this.createFactory();
        ClientSessionFactory cf = this.createSessionFactory(locator);
        this.session = cf.createSession();
        this.session.createQueue(new QueueConfiguration(queueName).setAddress(address).setRoutingType(RoutingType.ANYCAST));
        this.producer = this.session.createProducer(address);
        this.consumer = this.session.createConsumer(queueName);
        this.session.start();
    }

    private ClientMessage sendAndReceive(ClientMessage message) throws Exception {
        this.producer.send((Message)message);
        ClientMessage received = this.consumer.receive(10000L);
        return received;
    }
}

