/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.lang.ref.WeakReference;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class SessionCloseOnGCTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ServerLocator locator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testValidateFactoryGC1() throws Exception {
        ClientSessionFactory factory = this.locator.createSessionFactory();
        ClientSession s1 = factory.createSession();
        ClientSession s2 = factory.createSession();
        s1.close();
        s2.close();
        WeakReference<ClientSession> wrs1 = new WeakReference<ClientSession>(s1);
        WeakReference<ClientSession> wrs2 = new WeakReference<ClientSession>(s2);
        s1 = null;
        s2 = null;
        this.locator.close();
        this.locator = null;
        ActiveMQTestBase.checkWeakReferences((WeakReference[])new WeakReference[]{wrs1, wrs2});
        WeakReference<ClientSessionFactory> fref = new WeakReference<ClientSessionFactory>(factory);
        factory.close();
        factory = null;
        ActiveMQTestBase.checkWeakReferences((WeakReference[])new WeakReference[]{fref, wrs1, wrs2});
    }

    @Test
    public void testValidateFactoryGC2() throws Exception {
        this.locator.setUseGlobalPools(false);
        ClientSessionFactory factory = this.locator.createSessionFactory();
        ClientSession s1 = factory.createSession();
        ClientSession s2 = factory.createSession();
        s1.close();
        s2.close();
        WeakReference<ClientSession> wrs1 = new WeakReference<ClientSession>(s1);
        WeakReference<ClientSession> wrs2 = new WeakReference<ClientSession>(s2);
        s1 = null;
        s2 = null;
        this.locator.close();
        this.locator = null;
        ActiveMQTestBase.checkWeakReferences((WeakReference[])new WeakReference[]{wrs1, wrs2});
        WeakReference<ClientSessionFactory> fref = new WeakReference<ClientSessionFactory>(factory);
        factory.close();
        factory = null;
        ActiveMQTestBase.checkWeakReferences((WeakReference[])new WeakReference[]{fref, wrs1, wrs2});
    }

    @Test
    public void testValidateFactoryGC3() throws Exception {
        ClientSessionFactory factory = this.locator.createSessionFactory();
        ClientSession s1 = factory.createSession();
        ClientSession s2 = factory.createSession();
        s1.close();
        s2.close();
        WeakReference<ClientSession> wrs1 = new WeakReference<ClientSession>(s1);
        WeakReference<ClientSession> wrs2 = new WeakReference<ClientSession>(s2);
        s1 = null;
        s2 = null;
        this.locator.close();
        this.locator = null;
        ActiveMQTestBase.checkWeakReferences((WeakReference[])new WeakReference[]{wrs1, wrs2});
        WeakReference<ClientSessionFactory> fref = new WeakReference<ClientSessionFactory>(factory);
        factory = null;
        ActiveMQTestBase.checkWeakReferences((WeakReference[])new WeakReference[]{fref, wrs1, wrs2});
    }

    @Test
    public void testValidateFactoryGC4() throws Exception {
        ClientSessionFactory factory = this.locator.createSessionFactory();
        ClientSession s1 = factory.createSession();
        ClientSession s2 = factory.createSession();
        WeakReference<ClientSession> wrs1 = new WeakReference<ClientSession>(s1);
        WeakReference<ClientSession> wrs2 = new WeakReference<ClientSession>(s2);
        s1 = null;
        s2 = null;
        this.locator.close();
        this.locator = null;
        ActiveMQTestBase.checkWeakReferences((WeakReference[])new WeakReference[]{wrs1, wrs2});
        WeakReference<ClientSessionFactory> fref = new WeakReference<ClientSessionFactory>(factory);
        factory = null;
        ActiveMQTestBase.checkWeakReferences((WeakReference[])new WeakReference[]{fref, wrs1, wrs2});
    }

    @Test
    public void testValidateFactoryGC5() throws Exception {
        ClientSessionFactory factory = this.locator.createSessionFactory();
        WeakReference<ClientSessionFactory> fref = new WeakReference<ClientSessionFactory>(factory);
        factory = null;
        this.locator.close();
        this.locator = null;
        ActiveMQTestBase.checkWeakReferences((WeakReference[])new WeakReference[]{fref});
    }
}

