/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimpleSendMultipleQueuesTest
extends ActiveMQTestBase {
    public static final String address = "testaddress";
    public static final String queueName = "testqueue";
    private ActiveMQServer server;
    private ClientSession session;
    private ClientProducer producer;
    private ClientConsumer consumer1;
    private ClientConsumer consumer2;
    private ClientConsumer consumer3;
    private ServerLocator locator;

    @Test
    public void testSimpleSend() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = this.session.createMessage(false);
            String body = RandomUtil.randomString();
            message.getBodyBuffer().writeString(body);
            this.producer.send((Message)message);
            ClientMessage received1 = this.consumer1.receive(1000L);
            Assert.assertNotNull((Object)received1);
            Assert.assertEquals((Object)body, (Object)received1.getBodyBuffer().readString());
            ClientMessage received2 = this.consumer2.receive(1000L);
            Assert.assertNotNull((Object)received2);
            Assert.assertEquals((Object)body, (Object)received2.getBodyBuffer().readString());
            ClientMessage received3 = this.consumer3.receive(1000L);
            Assert.assertNotNull((Object)received3);
            Assert.assertEquals((Object)body, (Object)received3.getBodyBuffer().readString());
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, true);
        this.server.start();
        this.locator = this.createNettyNonHALocator();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        this.session = cf.createSession();
        this.session.createQueue(new QueueConfiguration("queue1").setAddress(address));
        this.session.createQueue(new QueueConfiguration("queue2").setAddress(address));
        this.session.createQueue(new QueueConfiguration("queue3").setAddress(address));
        this.producer = this.session.createProducer(address);
        this.consumer1 = this.session.createConsumer("queue1");
        this.consumer2 = this.session.createConsumer("queue2");
        this.consumer3 = this.session.createConsumer("queue3");
        this.session.start();
    }
}

