/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.clientcrash;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.clientcrash.ClientTestBase;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PendingDeliveriesTest
extends ClientTestBase {
    private static final String AMQP_URI = "amqp://localhost:61616?amqp.saslLayer=false";
    private static final String CORE_URI_NO_RECONNECT = "tcp://localhost:61616?confirmationWindowSize=-1";
    private static final String CORE_URI_WITH_RECONNECT = "tcp://localhost:61616?confirmationWindowSize=1048576";
    private static final int NUMBER_OF_MESSAGES = 100;

    @Before
    public void createQueue() throws Exception {
        this.server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"queue1"), RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration("queue1").setRoutingType(RoutingType.ANYCAST));
    }

    @After
    public void clearLogger() throws Exception {
        AssertionLoggerHandler.stopCapture();
        AssertionLoggerHandler.clear();
    }

    public static void main(String[] arg) {
        if (arg.length != 3) {
            System.err.println("Usage:: URI destinationName cleanShutdown");
            System.exit(-1);
        }
        String uri = arg[0];
        String destinationName = arg[1];
        boolean cleanShutdown = Boolean.valueOf(arg[2]);
        ConnectionFactory factory = PendingDeliveriesTest.createCF(uri);
        try {
            Connection connection = factory.createConnection();
            Session session = connection.createSession(false, 1);
            Queue destination = session.createQueue(destinationName);
            System.err.println("***** " + destination);
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            MessageProducer producer = session.createProducer((Destination)destination);
            for (int i = 0; i < 100; ++i) {
                producer.send((Message)session.createTextMessage("hello"));
            }
            System.err.println("CleanShutdown::" + cleanShutdown);
            if (cleanShutdown) {
                consumer.close();
                connection.close();
            }
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static ConnectionFactory createCF(String uri) {
        Object factory = uri.startsWith("amqp") ? new JmsConnectionFactory(uri) : new ActiveMQConnectionFactory(uri);
        return factory;
    }

    @Test
    public void testWithoutReconnect() throws Exception {
        this.internalNoReconnect(AMQP_URI, "queue1");
        this.internalNoReconnect(CORE_URI_NO_RECONNECT, "queue1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalNoReconnect(String uriToUse, String destinationName) throws Exception {
        this.startClient(uriToUse, destinationName, true, false);
        ConnectionFactory cf = PendingDeliveriesTest.createCF(uriToUse);
        Connection connection = cf.createConnection();
        connection.start();
        try {
            Session session = connection.createSession(false, 1);
            Queue destination = session.createQueue(destinationName);
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            for (int i = 0; i < 100; ++i) {
                Assert.assertNotNull((String)("consumer.receive(...) returned null for " + i + "th message. Number of expected messages to be received is " + 100), (Object)(i == 99 ? consumer.receive(500L) : consumer.receive(5000L)));
            }
        }
        finally {
            connection.stop();
            connection.close();
        }
        if (cf instanceof ActiveMQConnectionFactory) {
            ((ActiveMQConnectionFactory)cf).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithtReconnect() throws Exception {
        this.startClient(CORE_URI_WITH_RECONNECT, "queue1", true, false);
        ConnectionFactory cf = PendingDeliveriesTest.createCF(CORE_URI_WITH_RECONNECT);
        Connection connection = cf.createConnection();
        connection.start();
        try {
            Message msg;
            int i;
            Session session = connection.createSession(false, 1);
            Queue destination = session.createQueue("queue1");
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            for (i = 0; i < 100 && (msg = consumer.receive(1000L)) != null; ++i) {
            }
            Assert.assertTrue((i < 100 ? (byte)1 : 0) != 0);
        }
        finally {
            connection.stop();
            connection.close();
        }
    }

    @Test
    public void testCleanShutdownNoLogger() throws Exception {
        AssertionLoggerHandler.startCapture();
        this.startClient(CORE_URI_NO_RECONNECT, "queue1", false, true);
        Thread.sleep(500L);
        Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"clearing up resources"}));
    }

    @Test
    public void testBadShutdownLogger() throws Exception {
        AssertionLoggerHandler.startCapture();
        this.startClient(CORE_URI_NO_RECONNECT, "queue1", false, false);
        Assert.assertTrue((boolean)AssertionLoggerHandler.findText((long)1000L, (String[])new String[]{"clearing up resources"}));
    }

    @Test
    public void testCleanShutdown() throws Exception {
    }

    private void startClient(String uriToUse, String destinationName, boolean log, boolean cleanShutdown) throws Exception {
        Process process = SpawnedVMSupport.spawnVM((String)PendingDeliveriesTest.class.getName(), (boolean)log, (String[])new String[]{uriToUse, destinationName, Boolean.toString(cleanShutdown)});
        Assert.assertEquals((long)0L, (long)process.waitFor());
    }
}

