/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.component.WebServerComponent;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServiceComponent;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.WebServerDTO;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTest;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ReplicatedFailoverTest
extends FailoverTest {
    boolean isReplicatedFailbackTest = false;
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            ReplicatedFailoverTest.this.isReplicatedFailbackTest = description.getMethodName().equals("testReplicatedFailback") || description.getMethodName().equals("testLoop");
        }
    };

    protected void beforeWaitForRemoteBackupSynchronization() {
    }

    private void waitForSync(ActiveMQServer server) throws Exception {
        Wait.waitFor(() -> ((ActiveMQServer)server).isReplicaSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testReplicatedFailback() throws Exception {
        try {
            this.beforeWaitForRemoteBackupSynchronization();
            this.waitForSync(this.backupServer.getServer());
            this.createSessionFactory();
            ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
            session.createQueue(new QueueConfiguration(ADDRESS));
            this.crash(session);
            ReplicatedPolicy haPolicy = (ReplicatedPolicy)this.liveServer.getServer().getHAPolicy();
            haPolicy.setCheckForLiveServer(true);
            this.liveServer.start();
            this.waitForSync(this.liveServer.getServer());
            this.waitForSync(this.backupServer.getServer());
            this.waitForServerToStart(this.liveServer.getServer());
            session = this.createSession((ClientSessionFactory)this.sf, true, true);
            this.crash(session);
            ReplicatedPolicyConfiguration replicatedPolicyConfiguration = (ReplicatedPolicyConfiguration)this.liveServer.getServer().getConfiguration().getHAPolicyConfiguration();
            replicatedPolicyConfiguration.setCheckForLiveServer(true);
            this.liveServer.start();
            this.waitForSync(this.liveServer.getServer());
            this.waitForSync(this.backupServer.getServer());
            this.waitForServerToStart(this.liveServer.getServer());
            session = this.createSession((ClientSessionFactory)this.sf, true, true);
            this.crash(session);
            replicatedPolicyConfiguration = (ReplicatedPolicyConfiguration)this.liveServer.getServer().getConfiguration().getHAPolicyConfiguration();
            replicatedPolicyConfiguration.setCheckForLiveServer(true);
            this.liveServer.start();
            this.waitForSync(this.liveServer.getServer());
            this.backupServer.getServer().waitForActivation(5L, TimeUnit.SECONDS);
            this.waitForSync(this.liveServer.getServer());
            this.waitForServerToStart(this.backupServer.getServer());
            ReplicatedFailoverTest.assertTrue((boolean)this.backupServer.getServer().isStarted());
        }
        finally {
            if (this.sf != null) {
                this.sf.close();
            }
            try {
                this.liveServer.getServer().stop();
            }
            catch (Throwable throwable) {}
            try {
                this.backupServer.getServer().stop();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicatedFailbackBackupFromLiveBackToBackup() throws Exception {
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 8787);
        HttpServer httpServer = HttpServer.create(address, 100);
        httpServer.start();
        try {
            httpServer.createContext("/", new HttpHandler(){

                @Override
                public void handle(HttpExchange t) throws IOException {
                    String response = "<html><body><b>This is a unit test</b></body></html>";
                    t.sendResponseHeaders(200, response.length());
                    OutputStream os = t.getResponseBody();
                    os.write(response.getBytes());
                    os.close();
                }
            });
            WebServerDTO wdto = new WebServerDTO();
            AppDTO appDTO = new AppDTO();
            appDTO.war = "console.war";
            appDTO.url = "console";
            wdto.apps = new ArrayList();
            wdto.apps.add(appDTO);
            wdto.bind = "http://localhost:0";
            wdto.path = "console";
            WebServerComponent webServerComponent = new WebServerComponent();
            webServerComponent.configure((ComponentDTO)wdto, ".", ".");
            webServerComponent.start();
            this.backupServer.getServer().getNetworkHealthCheck().parseURIList("http://localhost:8787");
            Assert.assertTrue((boolean)this.backupServer.getServer().getNetworkHealthCheck().isStarted());
            this.backupServer.getServer().addExternalComponent((ActiveMQComponent)webServerComponent, false);
            this.backupServer.getServer().fail(true);
            Assert.assertTrue((boolean)this.backupServer.getServer().getNetworkHealthCheck().isStarted());
            Assert.assertTrue((boolean)((ActiveMQComponent)this.backupServer.getServer().getExternalComponents().get(0)).isStarted());
            ((ServiceComponent)this.backupServer.getServer().getExternalComponents().get(0)).stop(true);
        }
        finally {
            httpServer.stop(0);
        }
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        if (this.isReplicatedFailbackTest) {
            ((ReplicatedPolicyConfiguration)this.liveConfig.getHAPolicyConfiguration()).setCheckForLiveServer(true);
            ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
            ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setRestartBackup(false);
        } else {
            super.setupHAPolicyConfiguration();
        }
    }

    @Override
    protected void crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                ReplicatedFailoverTest.waitForRemoteBackup((ClientSessionFactory)session.getSessionFactory(), (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
            }
        } else {
            ReplicatedFailoverTest.waitForRemoteBackup(null, (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
        }
        super.crash(waitFailure, sessions);
    }

    @Override
    protected void crash(ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                ReplicatedFailoverTest.waitForRemoteBackup((ClientSessionFactory)session.getSessionFactory(), (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
            }
        } else {
            ReplicatedFailoverTest.waitForRemoteBackup(null, (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
        }
        super.crash(sessions);
    }
}

