/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Before;
import org.junit.Test;

public class ConsumerPriorityTest
extends JMSTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    protected ConnectionFactory getCF() throws Exception {
        return this.cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsumerPriorityQueueConsumerSettingUsingAddressQueueParameters() throws Exception {
        ConnectionFactory fact = this.getCF();
        String queueName = this.getName();
        try (Connection connection = fact.createConnection();){
            int j;
            Session session = connection.createSession(false, 2);
            Queue queue = session.createQueue(queueName);
            Queue queue1 = session.createQueue(queueName + "?consumer-priority=3");
            Queue queue2 = session.createQueue(queueName + "?consumer-priority=2");
            Queue queue3 = session.createQueue(queueName + "?consumer-priority=1");
            ConsumerPriorityTest.assertEquals((Object)queueName, (Object)queue.getQueueName());
            ActiveMQDestination b = (ActiveMQDestination)queue1;
            ConsumerPriorityTest.assertEquals((long)3L, (long)b.getQueueAttributes().getConsumerPriority().intValue());
            ConsumerPriorityTest.assertEquals((long)3L, (long)b.getQueueConfiguration().getConsumerPriority().intValue());
            ActiveMQDestination c = (ActiveMQDestination)queue2;
            ConsumerPriorityTest.assertEquals((long)2L, (long)c.getQueueAttributes().getConsumerPriority().intValue());
            ConsumerPriorityTest.assertEquals((long)2L, (long)c.getQueueConfiguration().getConsumerPriority().intValue());
            ActiveMQDestination d = (ActiveMQDestination)queue3;
            ConsumerPriorityTest.assertEquals((long)1L, (long)d.getQueueAttributes().getConsumerPriority().intValue());
            ConsumerPriorityTest.assertEquals((long)1L, (long)d.getQueueConfiguration().getConsumerPriority().intValue());
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer1 = session.createConsumer((Destination)queue1);
            MessageConsumer consumer2 = session.createConsumer((Destination)queue2);
            MessageConsumer consumer3 = session.createConsumer((Destination)queue3);
            connection.start();
            for (j = 0; j < 100; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                producer.send((Message)message);
            }
            for (j = 0; j < 100; ++j) {
                TextMessage tm = (TextMessage)consumer1.receive(10000L);
                ConsumerPriorityTest.assertNotNull((Object)tm);
                ConsumerPriorityTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
                tm = (TextMessage)consumer2.receiveNoWait();
                ConsumerPriorityTest.assertNull((Object)tm);
                tm = (TextMessage)consumer3.receiveNoWait();
                ConsumerPriorityTest.assertNull((Object)tm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsumerPriorityQueueConsumerRoundRobin() throws Exception {
        ConnectionFactory fact = this.getCF();
        String queueName = this.getName();
        try (Connection connection = fact.createConnection();){
            int j;
            Session session = connection.createSession(false, 2);
            Queue queue = session.createQueue(queueName);
            Queue queue1 = session.createQueue(queueName + "?consumer-priority=3");
            Queue queue2 = session.createQueue(queueName + "?consumer-priority=3");
            Queue queue3 = session.createQueue(queueName + "?consumer-priority=1");
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer1 = session.createConsumer((Destination)queue1);
            MessageConsumer consumer2 = session.createConsumer((Destination)queue2);
            MessageConsumer consumer3 = session.createConsumer((Destination)queue3);
            connection.start();
            for (j = 0; j < 100; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                message.setIntProperty("counter", j);
                producer.send((Message)message);
            }
            for (j = 0; j < 50; j += 2) {
                TextMessage tm = (TextMessage)consumer1.receive(10000L);
                ConsumerPriorityTest.assertNotNull((Object)tm);
                ConsumerPriorityTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
                TextMessage tm2 = (TextMessage)consumer2.receive(10000L);
                ConsumerPriorityTest.assertNotNull((Object)tm2);
                ConsumerPriorityTest.assertEquals((Object)("Message" + (j + 1)), (Object)tm2.getText());
                TextMessage tm3 = (TextMessage)consumer3.receiveNoWait();
                ConsumerPriorityTest.assertNull((Object)tm3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsumerPriorityQueueConsumerFailover() throws Exception {
        ConnectionFactory fact = this.getCF();
        String queueName = this.getName();
        try (Connection connection = fact.createConnection();){
            TextMessage tm;
            int j;
            Session session = connection.createSession(false, 2);
            Queue queue = session.createQueue(queueName);
            Queue queue1 = session.createQueue(queueName + "?consumer-priority=3");
            Queue queue2 = session.createQueue(queueName + "?consumer-priority=2");
            Queue queue3 = session.createQueue(queueName + "?consumer-priority=1");
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer1 = session.createConsumer((Destination)queue1);
            MessageConsumer consumer2 = session.createConsumer((Destination)queue2);
            MessageConsumer consumer3 = session.createConsumer((Destination)queue3);
            connection.start();
            for (j = 0; j < 100; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                producer.send((Message)message);
            }
            for (j = 0; j < 50; ++j) {
                tm = (TextMessage)consumer1.receive(10000L);
                ConsumerPriorityTest.assertNotNull((Object)tm);
                ConsumerPriorityTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
                tm = (TextMessage)consumer2.receiveNoWait();
                ConsumerPriorityTest.assertNull((Object)tm);
                tm = (TextMessage)consumer3.receiveNoWait();
                ConsumerPriorityTest.assertNull((Object)tm);
            }
            consumer1.close();
            for (j = 50; j < 100; ++j) {
                tm = (TextMessage)consumer2.receive(10000L);
                ConsumerPriorityTest.assertNotNull((Object)tm);
                ConsumerPriorityTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
                tm = (TextMessage)consumer3.receiveNoWait();
                ConsumerPriorityTest.assertNull((Object)tm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsumerPriorityTopicSharedConsumerFailover() throws Exception {
        ConnectionFactory fact = this.getCF();
        String topicName = this.getName();
        try (Connection connection = fact.createConnection();){
            TextMessage tm;
            int j;
            Session session = connection.createSession(false, 2);
            Topic topic = session.createTopic(topicName);
            MessageProducer producer = session.createProducer((Destination)topic);
            String subscriptionName = "sharedsub";
            Topic topicConsumer1 = session.createTopic(topicName + "?consumer-priority=3");
            Topic topicConsumer2 = session.createTopic(topicName + "?consumer-priority=2");
            Topic topicConsumer3 = session.createTopic(topicName + "?consumer-priority=1");
            MessageConsumer consumer1 = session.createSharedDurableConsumer(topicConsumer1, subscriptionName);
            MessageConsumer consumer2 = session.createSharedDurableConsumer(topicConsumer2, subscriptionName);
            MessageConsumer consumer3 = session.createSharedDurableConsumer(topicConsumer3, subscriptionName);
            connection.start();
            for (j = 0; j < 100; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                producer.send((Message)message);
            }
            for (j = 0; j < 50; ++j) {
                tm = (TextMessage)consumer1.receive(10000L);
                ConsumerPriorityTest.assertNotNull((Object)tm);
                ConsumerPriorityTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
                tm = (TextMessage)consumer2.receiveNoWait();
                ConsumerPriorityTest.assertNull((Object)tm);
                tm = (TextMessage)consumer3.receiveNoWait();
                ConsumerPriorityTest.assertNull((Object)tm);
            }
            consumer1.close();
            for (j = 50; j < 100; ++j) {
                tm = (TextMessage)consumer2.receive(10000L);
                ConsumerPriorityTest.assertNotNull((Object)tm);
                ConsumerPriorityTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
                tm = (TextMessage)consumer3.receiveNoWait();
                ConsumerPriorityTest.assertNull((Object)tm);
            }
        }
    }
}

