/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Test;

public class ExpiryMessageTest
extends JMSTestBase {
    @Override
    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        return super.createDefaultConfig(netty).setMessageExpiryScanPeriod(50L);
    }

    @Test
    public void testSendTopicNoSubscription() throws Exception {
        Topic topic = this.createTopic("test-topic");
        AddressControl control = ManagementControlHelper.createAddressControl(new SimpleString(topic.getTopicName()), this.mbeanServer);
        Connection conn2 = this.cf.createConnection();
        conn2.setClientID("client1");
        Session sess2 = conn2.createSession(true, 0);
        sess2.createDurableSubscriber(topic, "client-sub1");
        sess2.createDurableSubscriber(topic, "client-sub2");
        conn2.close();
        this.conn = this.cf.createConnection();
        Session sess = this.conn.createSession(true, 0);
        MessageProducer prod = sess.createProducer((Destination)topic);
        prod.setTimeToLive(100L);
        for (int i = 0; i < 100; ++i) {
            TextMessage txt = sess.createTextMessage("txt");
            prod.send((Message)txt);
        }
        sess.commit();
        this.conn.close();
        Wait.assertEquals((long)0L, () -> ((AddressControl)control).getMessageCount());
    }
}

