/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Test;

public class NoLocalSubscriberTest
extends JMSTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoLocal() throws Exception {
        Connection defaultConn = null;
        Connection newConn = null;
        try {
            Topic topic1 = this.createTopic("topic1");
            defaultConn = this.cf.createConnection();
            Session defaultSess = defaultConn.createSession(false, 1);
            MessageConsumer defaultConsumer = defaultSess.createConsumer((Destination)topic1);
            MessageConsumer noLocalConsumer = defaultSess.createConsumer((Destination)topic1, null, true);
            MessageProducer defaultProd = defaultSess.createProducer((Destination)topic1);
            defaultConn.start();
            String text = RandomUtil.randomString();
            TextMessage messageSent = defaultSess.createTextMessage(text);
            for (int i = 0; i < 10; ++i) {
                defaultProd.send((Message)messageSent);
            }
            Message received = null;
            for (int i = 0; i < 10; ++i) {
                received = defaultConsumer.receive(5000L);
                NoLocalSubscriberTest.assertNotNull((Object)received);
                NoLocalSubscriberTest.assertEquals((Object)text, (Object)((TextMessage)received).getText());
            }
            newConn = this.cf.createConnection();
            Session newSession = newConn.createSession(false, 1);
            MessageProducer newProd = newSession.createProducer((Destination)topic1);
            MessageConsumer newConsumer = newSession.createConsumer((Destination)topic1);
            newConn.start();
            text = RandomUtil.randomString();
            messageSent.setText(text);
            defaultProd.send((Message)messageSent);
            received = newConsumer.receive(5000L);
            NoLocalSubscriberTest.assertNotNull((Object)received);
            NoLocalSubscriberTest.assertEquals((Object)text, (Object)((TextMessage)received).getText());
            text = RandomUtil.randomString();
            messageSent.setText(text);
            newProd.send((Message)messageSent);
            newConn.close();
            received = noLocalConsumer.receive(5000L);
            NoLocalSubscriberTest.assertNotNull((String)"nolocal consumer did not get message", (Object)received);
            NoLocalSubscriberTest.assertEquals((Object)text, (Object)((TextMessage)received).getText());
        }
        finally {
            if (defaultConn != null) {
                defaultConn.close();
            }
            if (newConn != null) {
                newConn.close();
            }
        }
    }

    @Test
    public void testNoLocalReconnect() throws Exception {
        ConnectionFactory connectionFactory = this.cf;
        String uniqueID = Long.toString(System.currentTimeMillis());
        String topicName = "exampleTopic";
        String clientID = "myClientID_" + uniqueID;
        String subscriptionName = "mySub_" + uniqueID;
        boolean noLocal = true;
        String messageSelector = "";
        Topic topic = this.createTopic(topicName);
        Connection connection = connectionFactory.createConnection("guest", "guest");
        connection.setClientID(clientID);
        Session session = connection.createSession(false, 1);
        TopicSubscriber topicSubscriber = session.createDurableSubscriber(topic, subscriptionName, messageSelector, noLocal);
        topicSubscriber.close();
        connection.close();
        connection = connectionFactory.createConnection("guest", "guest");
        connection.setClientID(clientID);
        session = connection.createSession(false, 1);
        MessageProducer messageProducer = session.createProducer((Destination)topic);
        TextMessage textMessage = session.createTextMessage("M3");
        messageProducer.send((Message)textMessage);
        connection.close();
        connection = connectionFactory.createConnection("guest", "guest");
        connection.setClientID(clientID + "_different");
        session = connection.createSession(false, 1);
        messageProducer = session.createProducer((Destination)topic);
        textMessage = session.createTextMessage("M4");
        messageProducer.send((Message)textMessage);
        connection.close();
        connection = connectionFactory.createConnection("guest", "guest");
        connection.setClientID(clientID);
        session = connection.createSession(false, 1);
        topicSubscriber = session.createDurableSubscriber(topic, subscriptionName, messageSelector, noLocal);
        connection.start();
        textMessage = (TextMessage)topicSubscriber.receive(1000L);
        NoLocalSubscriberTest.assertNotNull((Object)textMessage);
        NoLocalSubscriberTest.assertEquals((Object)"M4", (Object)textMessage.getText());
        NoLocalSubscriberTest.assertNull((Object)topicSubscriber.receiveNoWait());
        connection.close();
    }

    @Test
    public void testNoLocalReconnect2() throws Exception {
        ConnectionFactory connectionFactory = this.cf;
        String uniqueID = Long.toString(System.currentTimeMillis());
        String topicName = "exampleTopic";
        String clientID = "myClientID_" + uniqueID;
        String subscriptionName = "mySub_" + uniqueID;
        boolean noLocal = true;
        String messageSelector = "";
        Topic topic = this.createTopic(topicName);
        Connection originalConnection = connectionFactory.createConnection("guest", "guest");
        originalConnection.setClientID(clientID);
        Session session = originalConnection.createSession(false, 1);
        TopicSubscriber topicSubscriber = session.createDurableSubscriber(topic, subscriptionName, messageSelector, noLocal);
        topicSubscriber.close();
        session.close();
        session = originalConnection.createSession(false, 1);
        MessageProducer messageProducer = session.createProducer((Destination)topic);
        messageProducer.send((Message)session.createTextMessage("M3"));
        session.close();
        Connection connection = connectionFactory.createConnection("guest", "guest");
        connection.setClientID(clientID + "_different");
        Session session2 = connection.createSession(false, 1);
        MessageProducer messageProducer2 = session2.createProducer((Destination)topic);
        messageProducer2.send((Message)session2.createTextMessage("M4"));
        connection.close();
        session = originalConnection.createSession(false, 1);
        topicSubscriber = session.createDurableSubscriber(topic, subscriptionName, messageSelector, noLocal);
        originalConnection.start();
        TextMessage textMessage = (TextMessage)topicSubscriber.receive(1000L);
        NoLocalSubscriberTest.assertNotNull((Object)textMessage);
        NoLocalSubscriberTest.assertEquals((Object)"M4", (Object)textMessage.getText());
        NoLocalSubscriberTest.assertNull((Object)topicSubscriber.receiveNoWait());
        originalConnection.close();
    }
}

