/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;

public class QueueAutoDeleteTest
extends JMSTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        return super.createDefaultConfig(netty).setAddressQueueScanPeriod(10L);
    }

    protected ConnectionFactory getCF() throws Exception {
        return this.cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDelete() throws Exception {
        ConnectionFactory fact = this.getCF();
        connection.start();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            String testQueueName = this.getName();
            jakarta.jms.Queue queue = session.createQueue(testQueueName + "?auto-delete=true");
            ActiveMQDestination activeMQDestination = (ActiveMQDestination)queue;
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            QueueAutoDeleteTest.assertEquals((Object)testQueueName, (Object)queue.getQueueName());
            QueueAutoDeleteTest.assertEquals((Object)true, (Object)activeMQDestination.getQueueAttributes().getAutoDelete());
            QueueAutoDeleteTest.assertEquals((Object)true, (Object)activeMQDestination.getQueueConfiguration().isAutoDelete());
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("hello1"));
            producer.send((Message)session.createTextMessage("hello2"));
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName));
            QueueAutoDeleteTest.assertTrue((boolean)queueBinding.getQueue().isAutoDelete());
            Wait.assertEquals((long)2L, () -> ((Queue)queueBinding.getQueue()).getMessageCount());
            Message message = consumer1.receive(5000L);
            QueueAutoDeleteTest.assertNotNull((Object)message);
            message.acknowledge();
            queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName));
            Wait.assertEquals((long)1L, () -> ((Queue)queueBinding.getQueue()).getMessageCount());
            MessageConsumer consumer2 = session.createConsumer((Destination)queue);
            consumer1.close();
            message = consumer2.receive(5000L);
            QueueAutoDeleteTest.assertNotNull((Object)message);
            message.acknowledge();
            consumer2.close();
            Wait.assertTrue(() -> this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName)) == null, (long)5000L, (long)10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDeleteTopicDurableSubscriptionQueue() throws Exception {
        ConnectionFactory fact = this.getCF();
        connection.start();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            String testQueueName = this.getName();
            String sub = testQueueName + "/mysub";
            Topic topic = session.createTopic(testQueueName + "?auto-delete=true");
            ActiveMQDestination activeMQDestination = (ActiveMQDestination)topic;
            QueueAutoDeleteTest.assertEquals((Object)testQueueName, (Object)topic.getTopicName());
            QueueAutoDeleteTest.assertEquals((Object)true, (Object)activeMQDestination.getQueueAttributes().getAutoDelete());
            QueueAutoDeleteTest.assertEquals((Object)true, (Object)activeMQDestination.getQueueConfiguration().isAutoDelete());
            MessageConsumer consumer = session.createSharedDurableConsumer(topic, sub);
            MessageConsumer consumerHolder = session.createSharedDurableConsumer(topic, sub);
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)sub));
            QueueAutoDeleteTest.assertTrue((boolean)queueBinding.getQueue().isAutoDelete());
            QueueAutoDeleteTest.assertEquals((long)0L, (long)queueBinding.getQueue().getMessageCount());
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.send((Message)session.createTextMessage("hello1"));
            producer.send((Message)session.createTextMessage("hello2"));
            Message message = consumer.receive(5000L);
            QueueAutoDeleteTest.assertNotNull((Object)message);
            QueueAutoDeleteTest.assertEquals((Object)"hello1", (Object)((TextMessage)message).getText());
            message.acknowledge();
            consumer.close();
            queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)sub));
            QueueAutoDeleteTest.assertNotNull((Object)queueBinding);
            consumer = session.createSharedDurableConsumer(topic, sub);
            consumerHolder.close();
            message = consumer.receive(5000L);
            QueueAutoDeleteTest.assertNotNull((Object)message);
            QueueAutoDeleteTest.assertEquals((Object)"hello2", (Object)((TextMessage)message).getText());
            message.acknowledge();
            consumer.close();
            Wait.assertTrue(() -> this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)sub)) == null, (long)5000L, (long)10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDeleteTopicDefaultDurableSubscriptionQueue() throws Exception {
        ConnectionFactory fact = this.getCF();
        connection.start();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            String testQueueName = this.getName();
            String sub = testQueueName + "/mysub";
            Topic topic = session.createTopic(testQueueName);
            QueueAutoDeleteTest.assertEquals((Object)testQueueName, (Object)topic.getTopicName());
            MessageConsumer consumer = session.createSharedDurableConsumer(topic, sub);
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)sub));
            QueueAutoDeleteTest.assertFalse((boolean)queueBinding.getQueue().isAutoDelete());
            Wait.assertEquals((long)0L, () -> ((Queue)queueBinding.getQueue()).getMessageCount());
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.send((Message)session.createTextMessage("hello1"));
            producer.send((Message)session.createTextMessage("hello2"));
            Message message = consumer.receive(5000L);
            QueueAutoDeleteTest.assertNotNull((Object)message);
            QueueAutoDeleteTest.assertEquals((Object)"hello1", (Object)((TextMessage)message).getText());
            message.acknowledge();
            consumer.close();
            queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)sub));
            QueueAutoDeleteTest.assertNotNull((Object)queueBinding);
            consumer = session.createSharedDurableConsumer(topic, sub);
            message = consumer.receive(5000L);
            QueueAutoDeleteTest.assertNotNull((Object)message);
            QueueAutoDeleteTest.assertEquals((Object)"hello2", (Object)((TextMessage)message).getText());
            message.acknowledge();
            consumer.close();
            Thread.sleep(20L);
            queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)sub));
            QueueAutoDeleteTest.assertNotNull((Object)queueBinding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDeleteOff() throws Exception {
        ConnectionFactory fact = this.getCF();
        connection.start();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            String testQueueName = this.getName();
            jakarta.jms.Queue queue = session.createQueue(testQueueName + "?auto-delete=false");
            ActiveMQDestination activeMQDestination = (ActiveMQDestination)queue;
            QueueAutoDeleteTest.assertEquals((Object)testQueueName, (Object)queue.getQueueName());
            QueueAutoDeleteTest.assertEquals((Object)false, (Object)activeMQDestination.getQueueAttributes().getAutoDelete());
            QueueAutoDeleteTest.assertEquals((Object)false, (Object)activeMQDestination.getQueueConfiguration().isAutoDelete());
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("hello1"));
            producer.send((Message)session.createTextMessage("hello2"));
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName));
            QueueAutoDeleteTest.assertFalse((boolean)queueBinding.getQueue().isAutoDelete());
            Wait.assertEquals((long)2L, () -> ((Queue)queueBinding.getQueue()).getMessageCount());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Message message = consumer.receive(5000L);
            QueueAutoDeleteTest.assertNotNull((Object)message);
            message.acknowledge();
            consumer.close();
            queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName));
            Wait.assertEquals((long)1L, () -> ((Queue)queueBinding.getQueue()).getMessageCount());
            consumer = session.createConsumer((Destination)queue);
            message = consumer.receive(5000L);
            QueueAutoDeleteTest.assertNotNull((Object)message);
            message.acknowledge();
            consumer.close();
            Thread.sleep(20L);
            queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName));
            QueueAutoDeleteTest.assertNotNull((Object)queueBinding);
            Wait.assertEquals((long)0L, () -> ((Queue)queueBinding.getQueue()).getMessageCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDeleteDelay() throws Exception {
        ConnectionFactory fact = this.getCF();
        connection.start();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            String testQueueName = this.getName();
            jakarta.jms.Queue queue = session.createQueue(testQueueName + "?auto-delete=true&auto-delete-delay=100");
            ActiveMQDestination activeMQDestination = (ActiveMQDestination)queue;
            QueueAutoDeleteTest.assertEquals((Object)testQueueName, (Object)queue.getQueueName());
            QueueAutoDeleteTest.assertEquals((Object)100L, (Object)activeMQDestination.getQueueAttributes().getAutoDeleteDelay());
            QueueAutoDeleteTest.assertEquals((Object)100L, (Object)activeMQDestination.getQueueConfiguration().getAutoDeleteDelay());
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("hello1"));
            producer.send((Message)session.createTextMessage("hello2"));
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName));
            QueueAutoDeleteTest.assertTrue((boolean)queueBinding.getQueue().isAutoDelete());
            QueueAutoDeleteTest.assertEquals((long)100L, (long)queueBinding.getQueue().getAutoDeleteDelay());
            Wait.assertEquals((long)2L, () -> ((Queue)queueBinding.getQueue()).getMessageCount());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Message message = consumer.receive(5000L);
            QueueAutoDeleteTest.assertNotNull((Object)message);
            message.acknowledge();
            consumer.close();
            queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName));
            Wait.assertEquals((long)1L, () -> ((Queue)queueBinding.getQueue()).getMessageCount());
            consumer = session.createConsumer((Destination)queue);
            message = consumer.receive(5000L);
            QueueAutoDeleteTest.assertNotNull((Object)message);
            message.acknowledge();
            consumer.close();
            Thread.sleep(50L);
            queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName));
            QueueAutoDeleteTest.assertNotNull((Object)queueBinding);
            Wait.assertTrue(() -> this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName)) == null, (long)5000L, (long)10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDeleteMessageCount() throws Exception {
        ConnectionFactory fact = this.getCF();
        connection.start();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            String testQueueName = this.getName();
            jakarta.jms.Queue queue = session.createQueue(testQueueName + "?auto-delete=true&auto-delete-message-count=1");
            ActiveMQDestination activeMQDestination = (ActiveMQDestination)queue;
            QueueAutoDeleteTest.assertEquals((Object)testQueueName, (Object)queue.getQueueName());
            QueueAutoDeleteTest.assertEquals((Object)1L, (Object)activeMQDestination.getQueueAttributes().getAutoDeleteMessageCount());
            QueueAutoDeleteTest.assertEquals((Object)1L, (Object)activeMQDestination.getQueueConfiguration().getAutoDeleteMessageCount());
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("hello1"));
            producer.send((Message)session.createTextMessage("hello2"));
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName));
            QueueAutoDeleteTest.assertTrue((boolean)queueBinding.getQueue().isAutoDelete());
            Wait.assertEquals((long)1L, () -> ((Queue)queueBinding.getQueue()).getAutoDeleteMessageCount());
            Wait.assertEquals((long)2L, () -> ((Queue)queueBinding.getQueue()).getMessageCount());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Message message = consumer.receive(5000L);
            QueueAutoDeleteTest.assertNotNull((Object)message);
            message.acknowledge();
            consumer.close();
            Thread.sleep(20L);
            Wait.assertTrue(() -> this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName)) == null, (long)5000L, (long)10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDeleteMessageCountDisabled() throws Exception {
        ConnectionFactory fact = this.getCF();
        connection.start();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            String testQueueName = this.getName();
            jakarta.jms.Queue queue = session.createQueue(testQueueName + "?auto-delete=true&auto-delete-message-count=-1");
            ActiveMQDestination activeMQDestination = (ActiveMQDestination)queue;
            QueueAutoDeleteTest.assertEquals((Object)testQueueName, (Object)queue.getQueueName());
            QueueAutoDeleteTest.assertEquals((Object)-1L, (Object)activeMQDestination.getQueueAttributes().getAutoDeleteMessageCount());
            QueueAutoDeleteTest.assertEquals((Object)-1L, (Object)activeMQDestination.getQueueConfiguration().getAutoDeleteMessageCount());
            MessageProducer producer = session.createProducer((Destination)queue);
            for (int i = 0; i < 100; ++i) {
                producer.send((Message)session.createTextMessage("hello" + i));
            }
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName));
            Wait.assertEquals((long)100L, () -> ((Queue)queueBinding.getQueue()).getMessageCount());
            QueueAutoDeleteTest.assertTrue((boolean)queueBinding.getQueue().isAutoDelete());
            QueueAutoDeleteTest.assertEquals((long)-1L, (long)queueBinding.getQueue().getAutoDeleteMessageCount());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Message message = consumer.receive(5000L);
            QueueAutoDeleteTest.assertNotNull((Object)message);
            message.acknowledge();
            consumer.close();
            Thread.sleep(20L);
            Wait.assertTrue(() -> this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName)) == null, (long)5000L, (long)10L);
        }
    }
}

