/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.connection;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;

public class ExceptionListenerForConnectionTimedOutExceptionTest
extends JMSTestBase {
    private Queue queue;
    static AtomicBoolean mayBlock = new AtomicBoolean(true);
    static AtomicBoolean blocked = new AtomicBoolean(false);
    static Packet lastPacketSent;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.queue = this.createQueue("TestQueue");
    }

    @Test(timeout=60000L)
    public void testOnAcknowledge() throws Exception {
        this.testOnAcknowledge(false);
    }

    @Test(timeout=60000L)
    public void testOnAcknowledgeBlockOnFailover() throws Exception {
        this.testOnAcknowledge(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOnAcknowledge(boolean blockOnFailover) throws Exception {
        mayBlock.set(blockOnFailover);
        Connection sendConnection = null;
        Connection connection = null;
        AtomicReference exceptionOnConnection = new AtomicReference();
        try {
            ((ActiveMQConnectionFactory)this.cf).setOutgoingInterceptorList(OutBoundPacketCapture.class.getName());
            ((ActiveMQConnectionFactory)this.cf).setIncomingInterceptorList(SessAcknowledgeCauseResponseTimeout.class.getName());
            ((ActiveMQConnectionFactory)this.cf).setBlockOnAcknowledge(true);
            ((ActiveMQConnectionFactory)this.cf).setCallTimeout(500L);
            sendConnection = this.cf.createConnection();
            Session sendSession = sendConnection.createSession(false, 1);
            MessageProducer producer = sendSession.createProducer((Destination)this.queue);
            TextMessage message = sendSession.createTextMessage();
            message.setText("Message");
            producer.send((Message)message);
            connection = this.cf.createConnection();
            connection.start();
            connection.setExceptionListener(exceptionOnConnection::set);
            Session consumerSession = connection.createSession(false, 2);
            MessageConsumer messageConsumer = consumerSession.createConsumer((Destination)this.queue);
            TextMessage message1 = (TextMessage)messageConsumer.receive(1000L);
            ExceptionListenerForConnectionTimedOutExceptionTest.assertEquals((Object)"Message", (Object)message1.getText());
            message1.acknowledge();
            ExceptionListenerForConnectionTimedOutExceptionTest.fail((String)"JMSException expected");
        }
        catch (JMSException e) {
            if (blockOnFailover) {
                Wait.assertTrue(blocked::get);
                ExceptionListenerForConnectionTimedOutExceptionTest.unblock();
            }
            ExceptionListenerForConnectionTimedOutExceptionTest.assertTrue((boolean)(e.getCause() instanceof ActiveMQConnectionTimedOutException));
            ExceptionListenerForConnectionTimedOutExceptionTest.assertTrue((boolean)Wait.waitFor(() -> exceptionOnConnection.get() != null, (long)2000L, (long)100L));
            ExceptionListenerForConnectionTimedOutExceptionTest.assertTrue((boolean)(((JMSException)((Object)exceptionOnConnection.get())).getCause() instanceof ActiveMQConnectionTimedOutException));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (sendConnection != null) {
                sendConnection.close();
            }
        }
    }

    @Test(timeout=60000L)
    public void testOnSend() throws Exception {
        this.testOnSend(false);
    }

    @Test(timeout=60000L)
    public void testOnSendBlockOnFailover() throws Exception {
        this.testOnSend(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOnSend(boolean blockOnFailover) throws Exception {
        mayBlock.set(blockOnFailover);
        Connection sendConnection = null;
        Object connection = null;
        AtomicReference exceptionOnConnection = new AtomicReference();
        try {
            ((ActiveMQConnectionFactory)this.cf).setOutgoingInterceptorList(OutBoundPacketCapture.class.getName());
            ((ActiveMQConnectionFactory)this.cf).setIncomingInterceptorList(SessSendCauseResponseTimeout.class.getName());
            ((ActiveMQConnectionFactory)this.cf).setCallTimeout(500L);
            sendConnection = this.cf.createConnection();
            sendConnection.setExceptionListener(exceptionOnConnection::set);
            Session sendSession = sendConnection.createSession(false, 1);
            MessageProducer producer = sendSession.createProducer((Destination)this.queue);
            TextMessage message = sendSession.createTextMessage();
            message.setText("Message");
            producer.send((Message)message);
            ExceptionListenerForConnectionTimedOutExceptionTest.fail((String)"JMSException expected");
        }
        catch (JMSException e) {
            if (blockOnFailover) {
                Wait.assertTrue(blocked::get);
                ExceptionListenerForConnectionTimedOutExceptionTest.unblock();
            }
            ExceptionListenerForConnectionTimedOutExceptionTest.assertTrue((boolean)(e.getCause() instanceof ActiveMQConnectionTimedOutException));
            ExceptionListenerForConnectionTimedOutExceptionTest.assertTrue((boolean)Wait.waitFor(() -> exceptionOnConnection.get() != null, (long)2000L, (long)100L));
            ExceptionListenerForConnectionTimedOutExceptionTest.assertTrue((boolean)(((JMSException)((Object)exceptionOnConnection.get())).getCause() instanceof ActiveMQConnectionTimedOutException));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (sendConnection != null) {
                sendConnection.close();
            }
        }
    }

    private static void block() {
        if (!mayBlock.get()) {
            return;
        }
        blocked.set(true);
        try {
            long timeOut = System.currentTimeMillis() + 5000L;
            while (mayBlock.get() && System.currentTimeMillis() < timeOut) {
                Thread.yield();
            }
        }
        finally {
            blocked.set(false);
        }
    }

    private static void unblock() {
        mayBlock.set(false);
    }

    public static class SessSendCauseResponseTimeout
    implements Interceptor {
        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == -5) {
                ExceptionListenerForConnectionTimedOutExceptionTest.block();
                return true;
            }
            return lastPacketSent.getType() != 71 || packet.getType() != 21;
        }
    }

    public static class SessAcknowledgeCauseResponseTimeout
    implements Interceptor {
        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == -5) {
                ExceptionListenerForConnectionTimedOutExceptionTest.block();
                return true;
            }
            return lastPacketSent.getType() != 41 || packet.getType() != 21;
        }
    }

    public static class OutBoundPacketCapture
    implements Interceptor {
        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            lastPacketSent = packet;
            return true;
        }
    }
}

