/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.Test;

public class VerySimpleOenwireTest
extends OpenWireTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenWireExample() throws Exception {
        Connection exConn = null;
        SimpleString durableQueue = new SimpleString("exampleQueue");
        this.server.createQueue(new QueueConfiguration(durableQueue).setRoutingType(RoutingType.ANYCAST));
        try {
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
            ActiveMQQueue queue = new ActiveMQQueue("exampleQueue");
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            VerySimpleOenwireTest.assertEquals((Object)"This is a text message", (Object)messageReceived.getText());
        }
        finally {
            if (exConn != null) {
                exConn.close();
            }
        }
    }

    @Test
    public void testMixedOpenWireExample() throws Exception {
        Connection openConn = null;
        SimpleString durableQueue = new SimpleString("exampleQueue");
        this.server.createQueue(new QueueConfiguration(durableQueue).setRoutingType(RoutingType.ANYCAST));
        ActiveMQConnectionFactory openCF = new ActiveMQConnectionFactory();
        ActiveMQQueue queue = new ActiveMQQueue("exampleQueue");
        openConn = openCF.createConnection();
        openConn.start();
        Session openSession = openConn.createSession(false, 1);
        MessageProducer producer = openSession.createProducer((Destination)queue);
        TextMessage message = openSession.createTextMessage("This is a text message");
        producer.send((Message)message);
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory artemisCF = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory();
        Connection artemisConn = artemisCF.createConnection();
        Session artemisSession = artemisConn.createSession(false, 1);
        artemisConn.start();
        MessageConsumer messageConsumer = artemisSession.createConsumer((Destination)artemisSession.createQueue("exampleQueue"));
        TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
        VerySimpleOenwireTest.assertEquals((Object)"This is a text message", (Object)messageReceived.getText());
        openConn.close();
        artemisConn.close();
    }
}

