/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.paging.SpawnedServerSupport;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;

public class PageCountSyncServer
extends SpawnedServerSupport {
    public static Process spawnVM(String testDir, long timeToRun) throws Exception {
        return SpawnedVMSupport.spawnVM((String)PageCountSyncServer.class.getName(), (String[])new String[]{testDir, "" + timeToRun});
    }

    public static Process spawnVMWithLogMacher(String wordMatch, Runnable runnable, String testDir, long timeToRun) throws Exception {
        return SpawnedVMSupport.spawnVMWithLogMacher((String)wordMatch, (Runnable)runnable, (String)PageCountSyncServer.class.getName(), null, (boolean)true, (String[])new String[]{testDir, "" + timeToRun});
    }

    public void perform(String folder, long timeToRun) throws Exception {
        try {
            ActiveMQServer server = PageCountSyncServer.createServer(folder);
            server.start();
            System.out.println("&*STARTED&*");
            System.out.println("Server started!!!");
            System.out.println("Waiting " + timeToRun + " seconds");
            Thread.sleep(timeToRun);
            System.out.println("Going down now!!!");
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] args) throws Exception {
        PageCountSyncServer ss = new PageCountSyncServer();
        System.out.println("Args.length = " + args.length);
        for (String arg : args) {
            System.out.println("Argument: " + arg);
        }
        if (args.length == 2) {
            ss.perform(args[0], Long.parseLong(args[1]));
        } else {
            System.err.println("you were expected to pass getTestDir as an argument on SpawnVMSupport");
        }
    }
}

