/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ssl;

import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.integration.security.SecurityTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DualAuthenticationTest
extends ActiveMQTestBase {
    public static final SimpleString QUEUE;
    private String SERVER_SIDE_KEYSTORE = "server-keystore.jks";
    private String SERVER_SIDE_TRUSTSTORE = "client-ca-truststore.jks";
    private String CLIENT_SIDE_TRUSTSTORE = "server-ca-truststore.jks";
    private String CLIENT_SIDE_KEYSTORE = "client-keystore.jks";
    private final String PASSWORD = "securepass";
    private ActiveMQServer server;
    private TransportConfiguration tc;

    @Test
    public void testDualAuthentication() throws Exception {
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("keyStorePath", this.CLIENT_SIDE_KEYSTORE);
        this.tc.getParams().put("keyStorePassword", "securepass");
        this.tc.getParams().put("port", "61617");
        ServerLocator producerLocator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory producerSessionFactory = this.createSessionFactory(producerLocator);
        ClientSession producerSession = producerSessionFactory.createSession(false, true, true);
        producerSession.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = producerSession.createProducer(QUEUE);
        ClientMessage message = this.createTextMessage(producerSession, text);
        producer.send((Message)message);
        ServerLocator consumerLocator = this.addServerLocator(ActiveMQClient.createServerLocator((String)"tcp://localhost:61616"));
        ClientSessionFactory consumerSessionFactory = this.createSessionFactory(consumerLocator);
        ClientSession consumerSession = consumerSessionFactory.createSession("consumer", "consumerPassword", false, true, true, consumerLocator.isPreAcknowledge(), consumerLocator.getAckBatchSize());
        ClientConsumer consumer = consumerSession.createConsumer(QUEUE);
        consumerSession.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", this.SERVER_SIDE_KEYSTORE);
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", this.SERVER_SIDE_TRUSTSTORE);
        params.put("trustStorePassword", "securepass");
        params.put("needClientAuth", true);
        params.put("port", "61617");
        ConfigurationImpl config = this.createBasicConfig();
        config.addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        config.addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY));
        config.setSecurityEnabled(true);
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("DualAuthenticationPropertiesLogin", "DualAuthenticationCertLogin");
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HierarchicalRepository securityRepository = this.server.getSecurityRepository();
        Role sendRole = new Role("producers", true, false, true, false, true, false, false, false, true, false);
        Role receiveRole = new Role("consumers", false, true, false, false, false, false, false, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(sendRole);
        roles.add(receiveRole);
        securityRepository.addMatch(QUEUE.toString(), roles);
        this.server.start();
        this.waitForServerToStart(this.server);
        this.tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
    }

    static {
        URL resource;
        QUEUE = new SimpleString("QueueOverSSL");
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SecurityTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

