/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting.impl.netty;

import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ServerConnectionLifeCycleListener;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.PortCheckRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NettyAcceptorTest
extends ActiveMQTestBase {
    private ScheduledExecutorService pool2;
    private ExecutorService pool3;

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        if (this.pool3 != null) {
            this.pool3.shutdown();
        }
        if (this.pool2 != null) {
            this.pool2.shutdownNow();
        }
        super.tearDown();
    }

    @Test
    public void testStartStop() throws Exception {
        BufferHandler handler = new BufferHandler(){

            public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            }
        };
        HashMap params = new HashMap();
        ServerConnectionLifeCycleListener listener = new ServerConnectionLifeCycleListener(){

            public void connectionException(Object connectionID, ActiveMQException me) {
            }

            public void connectionDestroyed(Object connectionID) {
            }

            public void connectionCreated(ActiveMQComponent component, Connection connection, ProtocolManager protocol) {
            }

            public void connectionReadyForWrites(Object connectionID, boolean ready) {
            }
        };
        this.pool2 = Executors.newScheduledThreadPool(ActiveMQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize(), (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        this.pool3 = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        NettyAcceptor acceptor = new NettyAcceptor("netty", null, params, handler, listener, this.pool2, (Executor)this.pool3, new HashMap());
        this.addActiveMQComponent((ActiveMQComponent)acceptor);
        acceptor.start();
        Assert.assertTrue((boolean)acceptor.isStarted());
        acceptor.stop();
        Assert.assertFalse((boolean)acceptor.isStarted());
        Assert.assertTrue((boolean)PortCheckRule.checkAvailable((int)61616));
        acceptor.start();
        Assert.assertTrue((boolean)acceptor.isStarted());
        acceptor.stop();
        Assert.assertFalse((boolean)acceptor.isStarted());
        Assert.assertTrue((boolean)PortCheckRule.checkAvailable((int)61616));
    }

    @Test
    public void testAutoStart() throws Exception {
        ActiveMQServer server = this.createServer(false, this.createDefaultInVMConfig());
        server.getConfiguration().addAcceptorConfiguration("default", "tcp://127.0.0.1:61617");
        server.getConfiguration().addAcceptorConfiguration("start", "tcp://127.0.0.1:61618?autoStart=true");
        server.getConfiguration().addAcceptorConfiguration("noStart", "tcp://127.0.0.1:61619?autoStart=false");
        server.start();
        NettyAcceptorTest.assertTrue((boolean)server.getRemotingService().getAcceptor("default").isStarted());
        NettyAcceptorTest.assertTrue((boolean)server.getRemotingService().getAcceptor("start").isStarted());
        NettyAcceptorTest.assertFalse((boolean)server.getRemotingService().getAcceptor("noStart").isStarted());
    }
}

