/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.function.Supplier;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.ConfigurationHelper;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.QueueDefinition;
import org.wildfly.extension.messaging.activemq.QueueService;

public class QueueAdd
extends AbstractAddStepHandler {
    public static final QueueAdd INSTANCE = new QueueAdd((AttributeDefinition[])QueueDefinition.ATTRIBUTES);

    private QueueAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attributeDefinition : QueueDefinition.ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName serviceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController serverService = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(context.getCurrentAddress()));
        if (serverService != null) {
            String queueName = context.getCurrentAddressValue();
            CoreQueueConfiguration queueConfiguration = ConfigurationHelper.createCoreQueueConfiguration(context, queueName, model);
            ServiceName queueServiceName = MessagingServices.getQueueBaseServiceName(serviceName).append(new String[]{queueName});
            ServiceBuilder sb = context.getServiceTarget().addService(queueServiceName);
            sb.requires(ActiveMQActivationService.getServiceName(serviceName));
            Supplier serverSupplier = sb.requires(serviceName);
            QueueService service = new QueueService(serverSupplier, queueConfiguration, false, true);
            sb.setInitialMode(ServiceController.Mode.PASSIVE);
            sb.setInstance((Service)service);
            sb.install();
        }
    }
}

