/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.Capabilities;
import org.wildfly.extension.messaging.activemq.ServerDefinition;

class SecurityDomainCheckHandler
implements OperationStepHandler {
    static final SecurityDomainCheckHandler INSTANCE = new SecurityDomainCheckHandler();

    private SecurityDomainCheckHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel();
        String legacyDomain = ServerDefinition.SECURITY_DOMAIN.resolveModelAttribute(context, model).asString();
        if (!ServerDefinition.ELYTRON_DOMAIN.resolveModelAttribute(context, model).isDefined() && ServerDefinition.SECURITY_DOMAIN.resolveModelAttribute(context, model).isDefined()) {
            context.registerAdditionalCapabilityRequirement(Capabilities.LEGACY_SECURITY_DOMAIN_CAPABILITY.getDynamicName(legacyDomain), Capabilities.ACTIVEMQ_SERVER_CAPABILITY.getDynamicName(context.getCurrentAddress()), ServerDefinition.SECURITY_DOMAIN.getName());
        } else {
            context.deregisterCapabilityRequirement(Capabilities.LEGACY_SECURITY_DOMAIN_CAPABILITY.getDynamicName(legacyDomain), Capabilities.ACTIVEMQ_SERVER_CAPABILITY.getDynamicName(context.getCurrentAddress()));
        }
    }
}

