/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import java.io.IOException;
import java.util.LinkedList;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.singleton.server.SingletonElectionCommand;

public class SingletonElectionCommandMarshaller
implements ProtoStreamMarshaller<SingletonElectionCommand> {
    private static final int CANDIDATE_INDEX = 1;
    private static final int ELECTED_INDEX = 2;

    public SingletonElectionCommand readFrom(ProtoStreamReader reader) throws IOException {
        LinkedList<Node> candidates = new LinkedList<Node>();
        Integer elected = null;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    candidates.add((Node)reader.readAny(Node.class));
                    continue block4;
                }
                case 2: {
                    elected = reader.readUInt32();
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return new SingletonElectionCommand(candidates, elected);
    }

    public void writeTo(ProtoStreamWriter writer, SingletonElectionCommand command) throws IOException {
        for (Node candidate : command.getCandidates()) {
            writer.writeAny(1, (Object)candidate);
        }
        Integer elected = command.getIndex();
        if (elected != null) {
            writer.writeUInt32(2, elected.intValue());
        }
    }

    public Class<? extends SingletonElectionCommand> getJavaClass() {
        return SingletonElectionCommand.class;
    }
}

