/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.te;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.te.TeluguStemmer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public final class TeluguStemFilter
extends TokenFilter {
    private final CharTermAttribute termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttribute = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);
    private final TeluguStemmer teluguStemmer = new TeluguStemmer();

    public TeluguStemFilter(TokenStream input) {
        super(input);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttribute.isKeyword()) {
                this.termAttribute.setLength(this.teluguStemmer.stem(this.termAttribute.buffer(), this.termAttribute.length()));
            }
            return true;
        }
        return false;
    }
}

