/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.SwitchableSubscriptionSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

public final class MultiRetryOp<T>
extends AbstractMultiOperator<T, T> {
    private final long times;
    private final Predicate<? super Throwable> onFailurePredicate;

    public MultiRetryOp(Multi<? extends T> upstream, Predicate<? super Throwable> onFailurePredicate, long times) {
        super(upstream);
        this.onFailurePredicate = onFailurePredicate;
        this.times = times;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        RetrySubscriber<T> subscriber = new RetrySubscriber<T>(this.upstream, this.onFailurePredicate, downstream, this.times);
        downstream.onSubscribe(subscriber);
        if (!subscriber.isCancelled()) {
            subscriber.resubscribe();
        }
    }

    static final class RetrySubscriber<T>
    extends SwitchableSubscriptionSubscriber<T> {
        private final Publisher<? extends T> upstream;
        private final AtomicInteger wip = new AtomicInteger();
        private long remaining;
        long produced;
        private final Predicate<? super Throwable> onFailurePredicate;

        RetrySubscriber(Publisher<? extends T> upstream, Predicate<? super Throwable> onFailurePredicate, MultiSubscriber<? super T> downstream, long attempts) {
            super(downstream);
            this.upstream = upstream;
            this.remaining = attempts;
            this.onFailurePredicate = onFailurePredicate;
        }

        @Override
        public void onItem(T t) {
            ++this.produced;
            this.downstream.onItem(t);
        }

        @Override
        public void onFailure(Throwable t) {
            if (this.testOnFailurePredicate(t)) {
                return;
            }
            long r = this.remaining;
            if (r != Long.MAX_VALUE) {
                if (r == 0L) {
                    this.downstream.onFailure(t);
                    return;
                }
                this.remaining = r - 1L;
            }
            this.resubscribe();
        }

        private boolean testOnFailurePredicate(Throwable t) {
            try {
                if (!this.onFailurePredicate.test(t)) {
                    this.cancel();
                    this.downstream.onFailure(t);
                    return true;
                }
            }
            catch (Throwable e) {
                this.cancel();
                this.downstream.onFailure(new CompositeException(e, t));
                return true;
            }
            return false;
        }

        void resubscribe() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.emitted(c);
                    }
                    this.upstream.subscribe(Infrastructure.onMultiSubscription(this.upstream, this));
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }
}

