/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.Predicate;
import org.reactivestreams.Subscription;

public class MultiSelectWhereOp<T>
extends AbstractMultiOperator<T, T> {
    private final Predicate<? super T> predicate;

    public MultiSelectWhereOp(Multi<? extends T> upstream, Predicate<? super T> predicate) {
        super(upstream);
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> subscriber) {
        ParameterValidation.nonNullNpe(subscriber, "subscriber");
        this.upstream.subscribe().withSubscriber(new MultiSelectWhereProcessor<T>(subscriber, this.predicate));
    }

    static final class MultiSelectWhereProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final Predicate<? super T> predicate;
        private boolean requestedMax = false;

        MultiSelectWhereProcessor(MultiSubscriber<? super T> downstream, Predicate<? super T> predicate) {
            super(downstream);
            this.predicate = predicate;
        }

        @Override
        public void onItem(T t) {
            boolean passed;
            if (this.isDone()) {
                return;
            }
            try {
                passed = this.predicate.test(t);
            }
            catch (Throwable exception) {
                this.failAndCancel(exception);
                return;
            }
            if (passed) {
                this.downstream.onItem(t);
            } else if (!this.requestedMax) {
                this.request(1L);
            }
        }

        @Override
        public void request(long numberOfItems) {
            Subscription subscription = this.getUpstreamSubscription();
            if (subscription != Subscriptions.CANCELLED) {
                if (numberOfItems <= 0L) {
                    this.onFailure(new IllegalArgumentException("Invalid number of request, must be greater than 0"));
                    return;
                }
                if (numberOfItems == Long.MAX_VALUE) {
                    this.requestedMax = true;
                }
                subscription.request(numberOfItems);
            }
        }
    }
}

