/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.FibonacciBackoffConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class FibonacciBackoffConfigImpl
implements FibonacciBackoffConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final FibonacciBackoff instance;
    private final boolean onMethod;
    private Long _maxDelay;
    private ChronoUnit _maxDelayUnit;

    private FibonacciBackoffConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.fibonacciBackoff;
        this.onMethod = method.annotationsPresentDirectly.contains(FibonacciBackoff.class);
    }

    public static FibonacciBackoffConfigImpl create(FaultToleranceMethod method) {
        if (method.fibonacciBackoff == null) {
            return null;
        }
        if (!io.smallrye.faulttolerance.autoconfig.Config.isEnabled(FibonacciBackoff.class, (MethodDescriptor)method.method)) {
            return null;
        }
        return new FibonacciBackoffConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return FibonacciBackoff.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public long maxDelay() {
        if (this._maxDelay == null) {
            Config config = ConfigProvider.getConfig();
            this._maxDelay = this.onMethod ? (Long)config.getOptionalValue(this.getConfigKeyForMethod("maxDelay"), Long.TYPE).orElse(null) : (Long)config.getOptionalValue(this.getConfigKeyForClass("maxDelay"), Long.TYPE).orElse(null);
            if (this._maxDelay == null) {
                this._maxDelay = config.getOptionalValue("FibonacciBackoff/maxDelay", Long.TYPE).orElse(null);
            }
            if (this._maxDelay == null) {
                this._maxDelay = this.instance.maxDelay();
            }
        }
        return this._maxDelay;
    }

    public ChronoUnit maxDelayUnit() {
        if (this._maxDelayUnit == null) {
            Config config = ConfigProvider.getConfig();
            this._maxDelayUnit = this.onMethod ? (ChronoUnit)config.getOptionalValue(this.getConfigKeyForMethod("maxDelayUnit"), ChronoUnit.class).orElse(null) : (ChronoUnit)config.getOptionalValue(this.getConfigKeyForClass("maxDelayUnit"), ChronoUnit.class).orElse(null);
            if (this._maxDelayUnit == null) {
                this._maxDelayUnit = config.getOptionalValue("FibonacciBackoff/maxDelayUnit", ChronoUnit.class).orElse(null);
            }
            if (this._maxDelayUnit == null) {
                this._maxDelayUnit = this.instance.maxDelayUnit();
            }
        }
        return this._maxDelayUnit;
    }

    private String getConfigKeyForMethod(String key) {
        return this.method.declaringClass.getName() + "/" + this.method.name + "/FibonacciBackoff/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return this.method.declaringClass.getName() + "/FibonacciBackoff/" + key;
    }

    public void materialize() {
        this.maxDelay();
        this.maxDelayUnit();
    }
}

