/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.SecurityActions;
import org.infinispan.commons.util.Util;
import org.wildfly.openssl.OpenSSLProvider;
import org.wildfly.openssl.SSL;

public class SslContextFactory {
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    private static final String CLASSPATH_RESOURCE = "classpath:";
    private static final String SSL_PROVIDER;
    private String keyStoreFileName;
    private char[] keyStorePassword;
    private char[] keyStoreCertificatePassword;
    private String keyStoreType = "JKS";
    private String keyAlias;
    private String trustStoreFileName;
    private char[] trustStorePassword;
    private String trustStoreType = "JKS";
    private String sslProtocol = "TLSv1.2";
    private boolean useNativeIfAvailable = true;
    private ClassLoader classLoader;

    public SslContextFactory keyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
        return this;
    }

    public SslContextFactory keyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public SslContextFactory keyStoreCertificatePassword(char[] keyStoreCertificatePassword) {
        this.keyStoreCertificatePassword = keyStoreCertificatePassword;
        return this;
    }

    public SslContextFactory keyStoreType(String keyStoreType) {
        if (keyStoreType != null) {
            this.keyStoreType = keyStoreType;
        }
        return this;
    }

    public SslContextFactory keyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this;
    }

    public SslContextFactory trustStoreFileName(String trustStoreFileName) {
        this.trustStoreFileName = trustStoreFileName;
        return this;
    }

    public SslContextFactory trustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public SslContextFactory trustStoreType(String trustStoreType) {
        if (trustStoreType != null) {
            this.trustStoreType = trustStoreType;
        }
        return this;
    }

    public SslContextFactory sslProtocol(String sslProtocol) {
        if (sslProtocol != null) {
            this.sslProtocol = sslProtocol;
        }
        return this;
    }

    public SslContextFactory useNativeIfAvailable(boolean useNativeIfAvailable) {
        this.useNativeIfAvailable = useNativeIfAvailable;
        return this;
    }

    public SslContextFactory classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public SSLContext getContext() {
        try {
            KeyManager[] keyManagers = null;
            if (this.keyStoreFileName != null) {
                KeyManagerFactory kmf = this.getKeyManagerFactory();
                keyManagers = kmf.getKeyManagers();
            }
            TrustManager[] trustManagers = null;
            if (this.trustStoreFileName != null) {
                TrustManagerFactory tmf = this.getTrustManagerFactory();
                trustManagers = tmf.getTrustManagers();
            }
            SSLContext sslContext = this.useNativeIfAvailable && SSL_PROVIDER != null ? SSLContext.getInstance(this.sslProtocol, SSL_PROVIDER) : SSLContext.getInstance(this.sslProtocol);
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            throw Log.SECURITY.sslInitializationException(e);
        }
    }

    public KeyManagerFactory getKeyManagerFactory() throws IOException, GeneralSecurityException {
        char[] keyPassword;
        KeyStore ks = KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : DEFAULT_KEYSTORE_TYPE);
        SslContextFactory.loadKeyStore(ks, this.keyStoreFileName, this.keyStorePassword, this.classLoader);
        char[] cArray = keyPassword = this.keyStoreCertificatePassword == null ? this.keyStorePassword : this.keyStoreCertificatePassword;
        if (this.keyAlias != null) {
            if (ks.containsAlias(this.keyAlias) && ks.isKeyEntry(this.keyAlias)) {
                KeyStore.PasswordProtection passParam = new KeyStore.PasswordProtection(keyPassword);
                KeyStore.Entry entry = ks.getEntry(this.keyAlias, passParam);
                ks = KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : DEFAULT_KEYSTORE_TYPE);
                ks.load(null);
                ks.setEntry(this.keyAlias, entry, passParam);
            } else {
                throw Log.SECURITY.noSuchAliasInKeyStore(this.keyAlias, this.keyStoreFileName);
            }
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keyPassword);
        return kmf;
    }

    public TrustManagerFactory getTrustManagerFactory() throws IOException, GeneralSecurityException {
        KeyStore ks = KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : DEFAULT_KEYSTORE_TYPE);
        SslContextFactory.loadKeyStore(ks, this.trustStoreFileName, this.trustStorePassword, this.classLoader);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        return tmf;
    }

    public static String getSslProvider() {
        return SSL_PROVIDER;
    }

    public static SSLEngine getEngine(SSLContext sslContext, boolean useClientMode, boolean needClientAuth) {
        SSLEngine sslEngine = sslContext.createSSLEngine();
        sslEngine.setUseClientMode(useClientMode);
        sslEngine.setNeedClientAuth(needClientAuth);
        return sslEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadKeyStore(KeyStore ks, String keyStoreFileName, char[] keyStorePassword, ClassLoader classLoader) throws IOException, GeneralSecurityException {
        InputStream is = null;
        try {
            if (keyStoreFileName.startsWith(CLASSPATH_RESOURCE)) {
                String fileName = keyStoreFileName.substring(keyStoreFileName.indexOf(":") + 1);
                is = Util.getResourceAsStream(fileName, classLoader);
                if (is == null) {
                    throw Log.SECURITY.cannotFindResource(keyStoreFileName);
                }
            } else {
                is = new BufferedInputStream(new FileInputStream(keyStoreFileName));
            }
            ks.load(is, keyStorePassword);
        }
        catch (Throwable throwable) {
            Util.close(is);
            throw throwable;
        }
        Util.close((AutoCloseable)is);
    }

    static {
        String sslProvider = null;
        if (Boolean.parseBoolean(SecurityActions.getProperty("org.infinispan.openssl", "true"))) {
            try {
                OpenSSLProvider.register();
                SSL.getInstance();
                sslProvider = "openssl";
                Log.SECURITY.openSSLAvailable();
            }
            catch (Throwable e) {
                Log.SECURITY.openSSLNotAvailable();
            }
        }
        SSL_PROVIDER = sslProvider;
    }
}

