/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.jackson.WhiteListPolymorphicTypeValidatorBuilder;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.AsyncOutputWriter;
import org.jboss.resteasy.spi.AsyncWriterInterceptor;
import org.jboss.resteasy.spi.AsyncWriterInterceptorContext;
import org.jboss.resteasy.spi.ResteasyConfiguration;

@Provider
@ConstrainedTo(value=RuntimeType.SERVER)
public class Jackson2JsonpInterceptor
implements AsyncWriterInterceptor {
    public static final MediaType TEXT_JAVASCRIPT_MEDIA_TYPE = new MediaType("text", "javascript");
    public static final MediaType APPLICATION_JAVASCRIPT_MEDIA_TYPE = new MediaType("application", "javascript");
    public static final MediaType TEXT_JSON_TYPE = new MediaType("text", "json");
    public static final MediaType APPLICATION_PLUS_JSON_TYPE = new MediaType("application", "*+json");
    public static final String DEFAULT_CALLBACK_QUERY_PARAMETER = "callback";
    public static final MediaTypeMap<String> jsonpCompatibleMediaTypes = new MediaTypeMap();
    protected static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private UriInfo uri;
    private String callbackQueryParameter = "callback";
    private boolean wrapInTryCatch = false;
    protected ObjectMapper objectMapper;
    protected Providers providers;
    private boolean enabled = false;

    public Jackson2JsonpInterceptor() {
        ResteasyConfiguration context = (ResteasyConfiguration)ResteasyContext.getContextData(ResteasyConfiguration.class);
        if (context != null) {
            this.wrapInTryCatch = Boolean.parseBoolean(context.getParameter("resteasy.jsonp.silent"));
            this.enabled = Boolean.parseBoolean(context.getParameter("resteasy.jsonp.enable"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : aroundWriteTo", (Object)this.getClass().getName());
        String function = (String)this.uri.getQueryParameters().getFirst((Object)this.callbackQueryParameter);
        if (this.enabled && function != null && !function.trim().isEmpty() && !jsonpCompatibleMediaTypes.getPossible(context.getMediaType()).isEmpty()) {
            OutputStreamWriter writer = new OutputStreamWriter(context.getOutputStream());
            if (this.wrapInTryCatch) {
                writer.write("try{");
            }
            writer.write(function + "(");
            writer.flush();
            OutputStream old = context.getOutputStream();
            DoNotCloseDelegateOutputStream wrappedOutputStream = new DoNotCloseDelegateOutputStream(old);
            context.setOutputStream((OutputStream)wrappedOutputStream);
            try {
                context.proceed();
                wrappedOutputStream.flush();
                writer.write(")");
                if (this.wrapInTryCatch) {
                    writer.write("}catch(e){}");
                }
                writer.flush();
            }
            finally {
                context.setOutputStream(old);
            }
        } else {
            context.proceed();
        }
    }

    public CompletionStage<Void> asyncAroundWriteTo(AsyncWriterInterceptorContext context) {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : aroundWriteTo", (Object)this.getClass().getName());
        String function = (String)this.uri.getQueryParameters().getFirst((Object)this.callbackQueryParameter);
        if (this.enabled && function != null && !function.trim().isEmpty() && !jsonpCompatibleMediaTypes.getPossible(context.getMediaType()).isEmpty()) {
            AsyncOutputWriter writer = new AsyncOutputWriter(context.getAsyncOutputStream());
            CompletionStage<Object> ret = CompletableFuture.completedFuture(null);
            if (this.wrapInTryCatch) {
                ret = ret.thenCompose(v -> writer.asyncWrite("try{"));
            }
            ret = ret.thenCompose(v -> writer.asyncWrite(function + "(")).thenCompose(v -> writer.asyncFlush()).thenCompose(v -> context.asyncProceed()).thenCompose(v -> writer.asyncFlush()).thenCompose(v -> writer.asyncWrite(")"));
            if (this.wrapInTryCatch) {
                ret = ret.thenCompose(v -> writer.asyncWrite("}catch(e){}"));
            }
            return ret.thenCompose(v -> writer.asyncFlush());
        }
        return context.asyncProceed();
    }

    protected ObjectMapper getObjectMapper(Class<?> type, MediaType mediaType) {
        if (this.objectMapper != null) {
            return this.objectMapper;
        }
        if (this.providers != null) {
            ContextResolver resolver = this.providers.getContextResolver(ObjectMapper.class, mediaType);
            if (resolver == null) {
                resolver = this.providers.getContextResolver(ObjectMapper.class, null);
            }
            if (resolver != null) {
                return (ObjectMapper)resolver.getContext(type);
            }
        }
        return DEFAULT_MAPPER;
    }

    @Context
    public void setUri(UriInfo uri) {
        this.uri = uri;
    }

    @Context
    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String getCallbackQueryParameter() {
        return this.callbackQueryParameter;
    }

    public void setCallbackQueryParameter(String callbackQueryParameter) {
        this.callbackQueryParameter = callbackQueryParameter;
    }

    public boolean isWrapInTryCatch() {
        return this.wrapInTryCatch;
    }

    public void setWrapInTryCatch(boolean wrapInTryCatch) {
        this.wrapInTryCatch = wrapInTryCatch;
    }

    static {
        DEFAULT_MAPPER.setPolymorphicTypeValidator((PolymorphicTypeValidator)new WhiteListPolymorphicTypeValidatorBuilder().build());
        jsonpCompatibleMediaTypes.add("application/json", (Object)MediaType.APPLICATION_JSON_TYPE.toString());
        jsonpCompatibleMediaTypes.add(APPLICATION_JAVASCRIPT_MEDIA_TYPE, (Object)APPLICATION_JAVASCRIPT_MEDIA_TYPE.toString());
        jsonpCompatibleMediaTypes.add(APPLICATION_PLUS_JSON_TYPE, (Object)APPLICATION_PLUS_JSON_TYPE.toString());
        jsonpCompatibleMediaTypes.add(TEXT_JSON_TYPE, (Object)TEXT_JSON_TYPE.toString());
        jsonpCompatibleMediaTypes.add(TEXT_JAVASCRIPT_MEDIA_TYPE, (Object)TEXT_JAVASCRIPT_MEDIA_TYPE.toString());
    }

    private static class DoNotCloseDelegateOutputStream
    extends BufferedOutputStream {
        DoNotCloseDelegateOutputStream(OutputStream delegate) {
            super(delegate);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }
}

