/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.evidence;

import java.util.Arrays;
import javax.security.auth.Destroyable;
import org.wildfly.common.Assert;
import org.wildfly.security.evidence.Evidence;

public final class PasswordGuessEvidence
implements Evidence,
Destroyable {
    private final char[] guess;
    private boolean destroyed;

    public PasswordGuessEvidence(char[] guess) {
        this.guess = (char[])Assert.checkNotNullParam((String)"guess", (Object)guess);
    }

    public char[] getGuess() {
        return this.guess;
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            Arrays.fill(this.guess, '\u0000');
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

