/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class FastHashtable<K, V>
extends Hashtable<K, V> {
    private static final long serialVersionUID = 85183000443454665L;
    private final ConcurrentHashMap<K, V> backingMap;

    public FastHashtable(int initialCapacity, float loadFactor) {
        super(0);
        this.backingMap = new ConcurrentHashMap(initialCapacity, loadFactor);
    }

    public FastHashtable(int initialCapacity) {
        super(0);
        this.backingMap = new ConcurrentHashMap(initialCapacity);
    }

    public FastHashtable() {
        super(0);
        this.backingMap = new ConcurrentHashMap();
    }

    public FastHashtable(Map<? extends K, ? extends V> t) {
        super(0);
        this.backingMap = new ConcurrentHashMap<K, V>(t instanceof FastHashtable ? ((FastHashtable)t).backingMap : t);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public V get(Object key) {
        return this.backingMap.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public V put(K key, V value) {
        return this.backingMap.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.backingMap.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.backingMap.remove(key);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    public ConcurrentHashMap.KeySetView<K, V> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.backingMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingMap.entrySet();
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        return this.backingMap.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.backingMap.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.backingMap.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.backingMap.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.backingMap.replace(key, value);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.backingMap.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.backingMap.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.backingMap.replaceAll(function);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.backingMap.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.backingMap.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.backingMap.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.backingMap.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public boolean contains(Object value) {
        return this.backingMap.contains(value);
    }

    @Override
    public Enumeration<K> keys() {
        return this.backingMap.keys();
    }

    @Override
    public Enumeration<V> elements() {
        return this.backingMap.elements();
    }

    @Override
    public FastHashtable<K, V> clone() {
        return new FastHashtable<K, V>(this);
    }

    @Override
    protected void rehash() {
    }

    public long mappingCount() {
        return this.backingMap.mappingCount();
    }

    public ConcurrentHashMap.KeySetView<K, V> keySet(V mappedValue) {
        return this.backingMap.keySet(mappedValue);
    }

    public static <K, V> FastHashtable<K, V> of(Hashtable<K, V> other) {
        if (other instanceof FastHashtable) {
            return (FastHashtable)other;
        }
        return new FastHashtable<K, V>(other);
    }
}

