/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.security;

import javax.naming.InvalidNameException;
import org.wildfly.naming.client.SimpleName;
import org.wildfly.naming.security.SimpleNamePermissions;
import org.wildfly.security.permission.AbstractActionSetPermission;
import org.wildfly.security.permission.AbstractPermission;
import org.wildfly.security.permission.AbstractPermissionCollection;
import org.wildfly.security.permission.SimplePermissionCollection;
import org.wildfly.security.util.StringEnumeration;

public abstract class AbstractNamingPermission<This extends AbstractNamingPermission<This>>
extends AbstractActionSetPermission<This> {
    private static final long serialVersionUID = -2355041296353728334L;
    private static final StringEnumeration actionStrings = StringEnumeration.of((String[])new String[]{"bind", "rebind", "unbind", "lookup", "list", "listBindings", "createSubcontext", "destroySubcontext", "addNamingListener"});
    private static final int ACTION_BIND = 1;
    private static final int ACTION_REBIND = 2;
    private static final int ACTION_UNBIND = 4;
    private static final int ACTION_LOOKUP = 8;
    private static final int ACTION_LIST = 16;
    private static final int ACTION_LIST_BINDINGS = 32;
    private static final int ACTION_CREATE_SUBCTXT = 64;
    private static final int ACTION_DESTROY_SUBCTXT = 128;
    private static final int ACTION_ADD_NAMING_LISTENER = 256;
    private static final int ALL = 511;
    private final SimpleName simpleName;

    protected AbstractNamingPermission(String name, String actions) throws InvalidNameException {
        this(new SimpleName(name), actions);
    }

    protected AbstractNamingPermission(SimpleName simpleName, String actions) {
        super(simpleName.toString(), actions, actionStrings);
        this.simpleName = simpleName;
    }

    protected AbstractNamingPermission(String name, int actionBits) throws InvalidNameException {
        this(new SimpleName(name), actionBits);
    }

    protected AbstractNamingPermission(SimpleName simpleName, int actionBits) {
        super(simpleName.toString(), actionBits, actionStrings);
        this.simpleName = simpleName;
    }

    public boolean impliesName(This permission) {
        return permission != null && this.impliesName(((AbstractNamingPermission)((Object)permission)).getSimpleName());
    }

    public boolean impliesName(String name) {
        try {
            return this.impliesName(new SimpleName(name));
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    public boolean impliesName(SimpleName otherName) {
        return SimpleNamePermissions.impliesName(this.simpleName, otherName);
    }

    public boolean nameEquals(String name) {
        try {
            return this.nameEquals(new SimpleName(name));
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    public boolean nameEquals(SimpleName name) {
        return this.simpleName.equals(name);
    }

    protected SimpleName getSimpleName() {
        return this.simpleName;
    }

    protected This constructWithActionBits(int actionBits) {
        return this.constructNew(this.simpleName, actionBits);
    }

    protected abstract This constructNew(SimpleName var1, int var2);

    public AbstractPermissionCollection newPermissionCollection() {
        return new SimplePermissionCollection((AbstractPermission)this);
    }
}

