/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.net;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.OptionalInt;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.marshalling.spi.net.NetExternalizerProvider;

public class InetSocketAddressExternalizer
implements Externalizer<InetSocketAddress> {
    public void writeObject(ObjectOutput output, InetSocketAddress socketAddress) throws IOException {
        InetAddress address = socketAddress.getAddress();
        NetExternalizerProvider.INET_ADDRESS.writeObject(output, address);
        IndexSerializer.UNSIGNED_SHORT.writeInt(output, socketAddress.getPort());
        if (address == null) {
            output.writeUTF(socketAddress.getHostName());
        }
    }

    public InetSocketAddress readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        InetAddress address = (InetAddress)NetExternalizerProvider.INET_ADDRESS.cast(InetAddress.class).readObject(input);
        int port = IndexSerializer.UNSIGNED_SHORT.readInt(input);
        return address != null ? new InetSocketAddress(address, port) : InetSocketAddress.createUnresolved(input.readUTF(), port);
    }

    public Class<InetSocketAddress> getTargetClass() {
        return InetSocketAddress.class;
    }

    public OptionalInt size(InetSocketAddress socketAddress) {
        int size = NetExternalizerProvider.INET_ADDRESS.size(socketAddress.getAddress()).getAsInt() + IndexSerializer.UNSIGNED_SHORT.size(socketAddress.getPort());
        if (socketAddress.getAddress() == null) {
            size += socketAddress.getHostName().length() + 1;
        }
        return OptionalInt.of(size);
    }
}

