/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import jakarta.servlet.ServletException;
import java.util.Map;

public class ErrorPages {
    private final Map<Integer, String> errorCodeLocations;
    private final Map<Class<? extends Throwable>, String> exceptionMappings;
    private final String defaultErrorPage;

    public ErrorPages(Map<Integer, String> errorCodeLocations, Map<Class<? extends Throwable>, String> exceptionMappings, String defaultErrorPage) {
        this.errorCodeLocations = errorCodeLocations;
        this.exceptionMappings = exceptionMappings;
        this.defaultErrorPage = defaultErrorPage;
    }

    public String getErrorLocation(int code) {
        String location = this.errorCodeLocations.get(code);
        if (location == null) {
            return this.defaultErrorPage;
        }
        return location;
    }

    public String getErrorLocation(Throwable exception) {
        if (exception == null) {
            return null;
        }
        String location = null;
        for (Class<?> c = exception.getClass(); c != null && location == null; c = c.getSuperclass()) {
            location = this.exceptionMappings.get(c);
        }
        if (location == null && exception instanceof ServletException) {
            Class<?> c;
            Throwable rootCause = ((ServletException)exception).getRootCause();
            while (rootCause != null && rootCause instanceof ServletException && location == null) {
                for (c = rootCause.getClass(); c != null && location == null; c = c.getSuperclass()) {
                    location = this.exceptionMappings.get(c);
                }
                rootCause = ((ServletException)rootCause).getRootCause();
            }
            if (rootCause != null && location == null) {
                for (c = rootCause.getClass(); c != null && location == null; c = c.getSuperclass()) {
                    location = this.exceptionMappings.get(c);
                }
            }
        }
        if (location == null) {
            location = this.getErrorLocation(500);
        }
        return location;
    }
}

