/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.ModuleServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.ServiceValueCaptorServiceConfigurator;
import org.jboss.as.clustering.controller.ServiceValueRegistry;
import org.jboss.as.clustering.jgroups.subsystem.ChannelClusterServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.ForkChannelFactoryServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.ForkResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.naming.BinderServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.JChannel;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.server.service.DistributedGroupServiceConfiguratorProvider;
import org.wildfly.clustering.server.service.ProvidedGroupServiceConfigurator;
import org.wildfly.clustering.service.IdentityServiceConfigurator;

public class ChannelServiceHandler
implements ResourceServiceHandler {
    private final ServiceValueRegistry<JChannel> registry;

    public ChannelServiceHandler(ServiceValueRegistry<JChannel> registry) {
        this.registry = registry;
    }

    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        String stack = ChannelResourceDefinition.Attribute.STACK.resolveModelAttribute((ExpressionResolver)context, model).asString();
        ServiceTarget target = context.getServiceTarget();
        new ChannelClusterServiceConfigurator(address).configure(context, model).build(target).install();
        ChannelServiceConfigurator channelBuilder = new ChannelServiceConfigurator((Capability)ChannelResourceDefinition.Capability.JCHANNEL, address).statisticsEnabled(ChannelResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean());
        channelBuilder.configure(context, model).build(target).install();
        new IdentityServiceConfigurator(ChannelResourceDefinition.Capability.JCHANNEL_FACTORY.getServiceName(address), JGroupsRequirement.CHANNEL_FACTORY.getServiceName(context, stack)).build(target).install();
        new ForkChannelFactoryServiceConfigurator((Capability)ChannelResourceDefinition.Capability.FORK_CHANNEL_FACTORY, address.append(new PathElement[]{ForkResourceDefinition.pathElement(name)})).configure(context, new ModelNode()).build(target).install();
        new ModuleServiceConfigurator(ChannelResourceDefinition.Capability.JCHANNEL_MODULE.getServiceName(address), (Attribute)ChannelResourceDefinition.Attribute.MODULE).configure(context, model).build(target).setInitialMode(ServiceController.Mode.PASSIVE).install();
        new ServiceValueCaptorServiceConfigurator(this.registry.add(channelBuilder.getServiceName())).build(target).install();
        new BinderServiceConfigurator(JGroupsBindingFactory.createChannelBinding(name), JGroupsRequirement.CHANNEL.getServiceName(context, name)).build(target).install();
        new BinderServiceConfigurator(JGroupsBindingFactory.createChannelFactoryBinding(name), JGroupsRequirement.CHANNEL_FACTORY.getServiceName(context, name)).build(target).install();
        new ProvidedGroupServiceConfigurator(DistributedGroupServiceConfiguratorProvider.class, name).configure(context).build(target).install();
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        for (ChannelResourceDefinition.Capability capability : EnumSet.allOf(ChannelResourceDefinition.Capability.class)) {
            context.removeService(capability.getServiceName(address));
        }
        context.removeService(JGroupsBindingFactory.createChannelBinding(name).getBinderServiceName());
        context.removeService(JGroupsBindingFactory.createChannelFactoryBinding(name).getBinderServiceName());
        new ProvidedGroupServiceConfigurator(DistributedGroupServiceConfiguratorProvider.class, name).remove(context);
        context.removeService(new ServiceValueCaptorServiceConfigurator(this.registry.remove(ChannelResourceDefinition.Capability.JCHANNEL.getServiceName(address))).getServiceName());
    }
}

